% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalModel.R
\name{predict.LocalModel}
\alias{predict.LocalModel}
\title{Predict LocalModel}
\usage{
\method{predict}{LocalModel}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{A LocalModel R6 object}

\item{newdata}{A data.frame for which to predict}

\item{...}{Further arguments for the objects predict function}
}
\value{
A data.frame with the predicted outcome.
}
\description{
Predict the response for newdata with the LocalModel model.
}
\examples{
library("randomForest")
# First we fit a machine learning model on the Boston housing data
data("Boston", package = "MASS")
X <- Boston[-which(names(Boston) == "medv")]
rf <- randomForest(medv ~ ., data = Boston, ntree = 50)
mod <- Predictor$new(rf, data = X)

# Explain the first instance of the dataset with the LocalModel method:
x.interest <- X[1, ]
lemon <- LocalModel$new(mod, x.interest = x.interest, k = 2)
predict(lemon, newdata = x.interest)
}
\seealso{
\link{LocalModel}
}
