% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalModel.R
\name{LocalModel}
\alias{LocalModel}
\title{LocalModel}
\description{
\code{LocalModel} fits locally weighted linear regression models (logistic
regression for classification) to explain single predictions of a prediction
model.
}
\details{
A weighted glm is fitted with the machine learning model prediction as
target. Data points are weighted by their proximity to the instance to be
explained, using the gower proximity measure. L1-regularization is used to
make the results sparse.

The resulting model can be seen as a surrogate for the machine learning
model, which is only valid for that one point. Categorical features are
binarized, depending on the category of the instance to be explained: 1 if
the category is the same, 0 otherwise.

Please note that scaling continuous features in the machine learning method
might be advisable when using LIME as an interpretation technique. LIME uses
a distance measure to compute proximity weights for the weighted glm. Hence,
the original scale of the features may influence the distance measure and
therewith LIME results.

To learn more about local models, read the Interpretable Machine Learning
book: \url{https://christophm.github.io/interpretable-ml-book/lime.html}

The approach is similar to LIME, but has the following differences:
\itemize{
\item \strong{Distance measure}: Uses as default the gower proximity (= 1 - gower
distance) instead of a kernel based on the Euclidean distance. Has the
advantage to have a meaningful neighborhood and no kernel width to tune.
When the distance is not \code{"gower"}, then the \code{\link[stats:dist]{stats::dist()}} function with the
chosen method will be used, and turned into a similarity measure:
\eqn{sqrt(exp(-(distance^2) / (kernel.width^2)))}.
\item \strong{Sampling}: Uses the original data instead of sampling from normal
distributions. Has the advantage to follow the original data distribution.
\item \strong{Visualization}: Plots effects instead of betas. Both are the same for binary
features, but ared different for numerical features. For numerical features,
plotting the betas makes no sense, because a negative beta might still
increase the prediction when the feature value is also negative.
}

To learn more about local surrogate models, read the Interpretable Machine
Learning book:
\url{https://christophm.github.io/interpretable-ml-book/lime.html}
}
\examples{
library("randomForest")
# First we fit a machine learning model on the Boston housing data
data("Boston", package = "MASS")
X <- Boston[-which(names(Boston) == "medv")]
rf <- randomForest(medv ~ ., data = Boston, ntree = 50)
mod <- Predictor$new(rf, data = X)

# Explain the first instance of the dataset with the LocalModel method:
x.interest <- X[1, ]
lemon <- LocalModel$new(mod, x.interest = x.interest, k = 2)
lemon

# Look at the results in a table
lemon$results
# Or as a plot
plot(lemon)

# Reuse the object with a new instance to explain
lemon$x.interest
lemon$explain(X[2, ])
lemon$x.interest
plot(lemon)

# LocalModel also works with multiclass classification
rf <- randomForest(Species ~ ., data = iris, ntree = 50)
X <- iris[-which(names(iris) == "Species")]
mod <- Predictor$new(rf, data = X, type = "prob", class = "setosa")

# Then we explain the first instance of the dataset with the LocalModel method:
lemon <- LocalModel$new(mod, x.interest = X[1, ], k = 2)
lemon$results
plot(lemon)
}
\references{
Ribeiro, M. T., Singh, S., & Guestrin, C. (2016). "Why Should I Trust You?":
Explaining the Predictions of Any Classifier. Retrieved from
http://arxiv.org/abs/1602.04938

Gower, J. C. (1971), "A general coefficient of similarity and some of its
properties". Biometrics, 27, 623--637.
}
\seealso{
\code{\link{plot.LocalModel}} and \code{\link{predict.LocalModel}}

\code{\link{Shapley}} can also be used to explain single predictions

The package \code{lime} with the original implementation
}
\section{Super class}{
\code{\link[iml:InterpretationMethod]{iml::InterpretationMethod}} -> \code{LocalModel}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{x.interest}}{\link{data.frame}\cr
Single row with the instance to be explained.}

\item{\code{k}}{\code{numeric(1)}\cr
The number of features as set by the user.}

\item{\code{model}}{\code{glmnet}\cr
The fitted local model.}

\item{\code{best.fit.index}}{\code{numeric(1)}\cr
The index of the best glmnet fit.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LocalModel-new}{\code{LocalModel$new()}}
\item \href{#method-LocalModel-predict}{\code{LocalModel$predict()}}
\item \href{#method-LocalModel-explain}{\code{LocalModel$explain()}}
\item \href{#method-LocalModel-clone}{\code{LocalModel$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="iml" data-topic="InterpretationMethod" data-id="plot"><a href='../../iml/html/InterpretationMethod.html#method-InterpretationMethod-plot'><code>iml::InterpretationMethod$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="iml" data-topic="InterpretationMethod" data-id="print"><a href='../../iml/html/InterpretationMethod.html#method-InterpretationMethod-print'><code>iml::InterpretationMethod$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LocalModel-new"></a>}}
\if{latex}{\out{\hypertarget{method-LocalModel-new}{}}}
\subsection{Method \code{new()}}{
Create a Local Model object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LocalModel$new(
  predictor,
  x.interest,
  dist.fun = "gower",
  gower.power = 1,
  kernel.width = NULL,
  k = 3
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictor}}{\link{Predictor}\cr
The object (created with \code{Predictor$new()}) holding the machine
learning model and the data.}

\item{\code{x.interest}}{\link{data.frame}\cr
Single row with the instance to be explained.}

\item{\code{dist.fun}}{\code{character(1)})\cr
The name of the distance function for computing proximities (weights in
the linear model). Defaults to \code{"gower"}. Otherwise will be forwarded
to \link[stats:dist]{stats::dist}.}

\item{\code{gower.power}}{(\code{numeric(1)})\cr
The calculated gower proximity will be raised to the power of this
value. Can be used to specify the size of the neighborhood for the
LocalModel (similar to kernel.width for the euclidean distance).}

\item{\code{kernel.width}}{(\code{numeric(1)})\cr
The width of the kernel for the proximity computation.
Only used if dist.fun is not \code{"gower"}.}

\item{\code{k}}{\code{numeric(1)}\cr
The number of features.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{data.frame}\cr
Results with the feature names (\code{feature}) and contributions to the
prediction.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LocalModel-predict"></a>}}
\if{latex}{\out{\hypertarget{method-LocalModel-predict}{}}}
\subsection{Method \code{predict()}}{
Method to predict new data with the local model See also
\link{predict.LocalModel}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LocalModel$predict(newdata = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{\link{data.frame}\cr
Data to predict on.}

\item{\code{...}}{Not used}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LocalModel-explain"></a>}}
\if{latex}{\out{\hypertarget{method-LocalModel-explain}{}}}
\subsection{Method \code{explain()}}{
Set a new data point to explain.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LocalModel$explain(x.interest)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x.interest}}{\link{data.frame}\cr
Single row with the instance to be explained.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LocalModel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LocalModel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LocalModel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
