% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{yeast4}
\alias{yeast4}
\title{Imbalanced binary yeast protein localization sites}
\format{A data frame with 1484 instances, 51 of which belong to positive class,
and 9 variables:

\describe{
  \item{Mcg}{McGeoch's method for signal sequence recognition.
    Continuous attribute.}
  \item{Gvh}{Von Heijne's method for signal sequence recognition.
    Continuous attribute.}
  \item{Alm}{Score of the ALOM membrane spanning region prediction program.
    Continuous attribute.}
  \item{Mit}{Score of discriminant analysis of the amino acid content of the
    N-terminal region (20 residues long) of mitochondrial and non-mitochondrial
    proteins. Continuous attribute.}
  \item{Erl}{Presence of "HDEL" substring (thought to act as a signal for
    retention in the endoplasmic reticulum lumen). Binary attribute. Discrete
    attribute.}
  \item{Pox}{Peroxisomal targeting signal in the C-terminus. Continuous attribute.}
  \item{Vac}{Score of discriminant analysis of the amino acid content of vacuolar
    and extracellular proteins. Continuous attribute.}
  \item{Nuc}{Score of discriminant analysis of nuclear localization signals of
    nuclear and non-nuclear proteins. Continuous attribute.}
  \item{Class}{Two possible classes: positive (membrane protein, uncleaved signal),
    negative (rest of localizations).}
}}
\source{
\href{http://sci2s.ugr.es/keel/datasets.php}{KEEL Repository}.
}
\usage{
yeast4
}
\description{
Imbalanced binary dataset containing protein traits for predicting their cellular
localization sites.
}
\seealso{
Original available in \href{https://archive.ics.uci.edu/ml}{UCI ML Repository}.
}
\keyword{datasets}
