% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwo.R
\name{rwo}
\alias{rwo}
\title{Random walk oversampling}
\usage{
rwo(dataset, numInstances, classAttr = "Class")
}
\arguments{
\item{dataset}{\code{data.frame} to treat. All columns, except
\code{classAttr} one, have to be numeric or coercible to numeric.}

\item{numInstances}{Integer. Number of new minority examples to generate.}

\item{classAttr}{\code{character}. Indicates the class attribute from
\code{dataset}. Must exist in it.}
}
\value{
A \code{data.frame} with the same structure as \code{dataset},
  containing the generated synthetic examples.
}
\description{
Generates synthetic minority examples for a dataset trying to preserve the
variance and mean of the minority class. Works on every type of dataset.
}
\details{
Generates \code{numInstances} new minority examples for \code{dataset},
adding to the each numeric column of the j-th example its variance scalated
by the inverse of the number of minority examples and a factor following a
\eqn{N(0,1)} distribution which depends on the example. When the column is
nominal, it uses a roulette scheme.
}
\examples{
data(iris0)

newSamples <- rwo(iris0, numInstances = 100, classAttr = "Class")

}
\references{
Zhang, Huaxiang; Li, Mingfang. Rwo-Sampling: A Random Walk Over-Sampling
Approach To Imbalanced Data Classification. Information Fusion 20 (2014), p.
99–116.
}
