checkArgs <- function(imagineArgs, type){

  output <- switch(type,
                   convolution2D       = checkArgs_convolution2D(imagineArgs),
                   convolutionQuantile = checkArgs_convolutionQuantile(imagineArgs),
                   meanFilter          = checkArgs_meanFilter(imagineArgs),
                   quantileFilter      = checkArgs_quantileFilter(imagineArgs),
                   "Invalid value for 'type'.")

  return(output)
}


checkArgs_convolution2D <- function(allArgs){

  dataMatrix <- allArgs$dataMatrix
  kernel <- allArgs$kernel
  times <- allArgs$times

  if(class(dataMatrix) != "matrix" || mode(dataMatrix) != "numeric"){
    stop("'datMatrix' must be a numeric matrix.")
  }

  if(class(kernel) != "matrix" || mode(kernel) != "numeric"){
    stop("'kernel' must be a numeric matrix.")
  }

  if((nrow(kernel) >= nrow(dataMatrix)) || ncol(kernel) >= ncol(dataMatrix)){
    stop("Dimensions of 'kernel' matrix must be less than the 'dataMatrix'.")
  }

  kernel <- matrix(data = round(an(kernel), 0), nrow = nrow(kernel))

  if(length(times) != 1 || mode(times) != "numeric"){
    stop("'time' must be a numeric vector with length 1.")
  }

  times <- as.integer(times)

  return(allArgs)
}

checkArgs_convolutionQuantile <- function(allArgs){

  dataMatrix <- allArgs$dataMatrix
  kernel <- allArgs$kernel
  x <- allArgs$x
  times <- allArgs$times

  if(class(dataMatrix) != "matrix" || mode(dataMatrix) != "numeric"){
    stop("'datMatrix' must be a numeric matrix.")
  }

  if(class(kernel) != "matrix" || mode(kernel) != "numeric"){
    stop("'kernel' must be a numeric matrix.")
  }

  if((nrow(kernel) >= nrow(dataMatrix)) || ncol(kernel) >= ncol(dataMatrix)){
    stop("Dimensions of 'kernel' matrix must be less than the 'dataMatrix'.")
  }

  kernel <- matrix(data = round(an(kernel), 0), nrow = nrow(kernel))

  if(class(x) != "numeric" || length(x) != 1 || x < 0 || x > 1){
    stop("'x' must be a numeric between 0 and 1 with length = 1.")
  }

  if(length(times) != 1 || mode(times) != "numeric"){
    stop("'time' must be a numeric vector with length 1.")
  }

  times <- as.integer(times)

  return(allArgs)
}

checkArgs_meanFilter <- function(allArgs){

  dataMatrix <- allArgs$dataMatrix
  radius <- allArgs$radius
  times <- allArgs$times

  if(class(dataMatrix) != "matrix" || mode(dataMatrix) != "numeric"){
    stop("'datMatrix' must be a numeric matrix.")
  }

  if(length(radius) != 1 || mode(radius) != "numeric"){
    stop("'radius' must be a numeric vector of length 1.")
  }

  if(radius > nrow(dataMatrix) || radius > ncol(dataMatrix)){
    stop("'radius' must be less than the dimensions (number of row and columns) of 'dataMatrix'.")
  }

  radius <- as.integer(radius)

  if(length(times) != 1 || mode(times) != "numeric"){
    stop("'time' must be a numeric vector with length 1.")
  }

  times <- as.integer(times)

  return(allArgs)
}

checkArgs_quantileFilter <- function(allArgs){

  dataMatrix <- allArgs$dataMatrix
  radius <- allArgs$radius
  x <- allArgs$x
  times <- allArgs$times

  if(class(dataMatrix) != "matrix" || mode(dataMatrix) != "numeric"){
    stop("'datMatrix' must be a numeric matrix.")
  }

  if(length(radius) != 1 || mode(radius) != "numeric"){
    stop("'radius' must be a numeric vector of length 1.")
  }

  if(radius > nrow(dataMatrix) || radius > ncol(dataMatrix)){
    stop("'radius' must be less than the dimensions (number of row and columns) of 'dataMatrix'.")
  }

  radius <- as.integer(radius)

  if(class(x) != "numeric" || length(x) != 1 || x < 0 || x > 1){
    stop("'x' must be a numeric between 0 and 1 with length = 1.")
  }

  if(length(times) != 1 || mode(times) != "numeric"){
    stop("'time' must be a numeric vector with length 1.")
  }

  times <- as.integer(times)

  return(allArgs)
}
