% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagine-main.R
\name{meanFilter}
\alias{meanFilter}
\alias{quantileFilter}
\alias{medianFilter}
\title{Make a 2D filter calculations from numeric matrix}
\usage{
meanFilter(dataMatrix, radius, times = 1)

quantileFilter(dataMatrix, radius, x, times = 1)

medianFilter(dataMatrix, radius, times = 1)
}
\arguments{
\item{dataMatrix}{A \code{numeric matrix} object used for apply filters.}

\item{radius}{Size of squared kernel to apply median.}

\item{times}{How many times do you want to apply the filter?}

\item{x}{\code{numeric} vector of probabilities with values in [0,1].}
}
\value{
\code{meanFilter} returns a \code{matrix} object with the same dimensions of \code{dataMatrix}.

\code{quantileFilter} don't use a kernel but, for each cell, it returns the position
of quantile 'x' (value between 0 and 1).

\code{medianFilter} is a wrapper of \code{quantileFilter} with x = 0.5.
}
\description{
This functions take a \code{matrix} object, and for each cell multiplies its neighborhood by
the squared matrix of dimension \eqn{radius*radius}. Finally and according to the type of function, they
return for each cell the mean, median or the quantile of the weighted sum.
}
\details{
Functions use the \code{engine4} and \code{engine5} C++ algorithms. More details are shown in vignette.
}
\examples{
# Generate example matrix
nRows <- 50
nCols <- 100

myMatrix <- matrix(runif(nRows*nCols, 0, 100), nrow = nRows, ncol = nCols)
radius <- 3

# Make convolution
myOutput1 <- meanFilter(myMatrix, radius)
myOutput2 <- quantileFilter(myMatrix, radius, 0.1)
myOutput3 <- medianFilter(myMatrix, radius)

# Plot results
image(myMatrix, zlim = c(0, 100))
image(myOutput1, zlim = c(0, 100))
image(myOutput2, zlim = c(0, 100))
image(myOutput3, zlim = c(0, 100))
}
