% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imeval.R
\name{imchange}
\alias{imchange}
\title{Modify parts of an image}
\usage{
imchange(obj, where, fo, env = parent.frame())
}
\arguments{
\item{obj}{an image or imlist}

\item{where}{where to modify. a pixset, or a formula (in imeval syntax) that evaluates to a pixset.}

\item{fo}{a formula (in imeval syntax) used to modify the image part}

\item{env}{evulation environment (see imeval)}
}
\value{
a modified image
}
\description{
A shortcut for modifying parts of an image, using imeval syntax. See doc for imeval first. As part of a pipe, avoids the creating of intermediate variables.
}
\examples{
\dontshow{cimg.limit.openmp()}
#Set border to 0:
imchange(boats,px.borders(boats,10),~ 0) \%>\% plot
#Eq. to
im <- boats
im[px.borders(im,10)] <- 0
#Using formula syntax
imchange(boats,~ px.borders(.,10),~ 0)
#Replace with grayscale ramp
imchange(boats,~ px.borders(.,10),~ xs) \%>\% plot
#Kill red channel in image
imchange(boats,~ c==1,~ 0) \%>\% plot
#Shit hue by an amount depending on eccentricity
load.example("parrots") \%>\%
  RGBtoHSL \%>\%
  imchange(~ c==1,~ .+80*exp(-(rho/550)^2) ) \%>\%
  HSLtoRGB \%>\%
  plot

}
\seealso{
imeval
}
\author{
Simon Barthelme
}
