% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basegraphics.R
\name{implot}
\alias{implot}
\title{Plot objects on image using base graphics}
\usage{
implot(im, expr, ...)
}
\arguments{
\item{im}{an image (class cimg)}

\item{expr}{an expression (graphics code to execute)}

\item{...}{passed on to plot.cimg, to control the initial rendering of the image (for example the colorscale)}
}
\value{
an image
}
\description{
This function lets you use an image as a canvas for base graphics, meaning you can use R functions like "text" and "points" to plot things on an image.
The function takes as argument an image and an expression, executes the expression with the image as canvas, and outputs the result as an image (of the same size).
}
\examples{
b.new <- implot(boats,text(150,50,"Boats!!!",cex=3))
plot(b.new)
#Draw a line on a white background
bg <- imfill(150,150,val=1)
implot(bg,lines(c(50,50),c(50,100),col="red",lwd=4))\%>\%plot
#You can change the rendering of the initial image
im <- grayscale(boats)
draw.fun <- function() text(150,50,"Boats!!!",cex=3)
out <- implot(im,draw.fun(),colorscale=function(v) rgb(0,v,v),rescale=FALSE)
plot(out)
}
\seealso{
plot, capture.plot
}
\author{
Simon Barthelme
}
