% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{contours}
\alias{contours}
\title{Return contours of image/pixset}
\usage{
contours(x, nlevels, ...)
}
\arguments{
\item{x}{an image or pixset}

\item{nlevels}{number of contour levels. For pixsets this can only equal two.}

\item{...}{extra parameters passed to contourLines}
}
\value{
a list of contours
}
\description{
This is just a light interface over contourLines. See help for contourLines for details.
If the image has more than one colour channel, return a list with the contour lines in each channel.
Does not work on 3D images.
}
\examples{
boats.gs <- grayscale(boats)
ct <- contours(boats.gs,nlevels=3)
plot(boats.gs)
#Add contour lines
purrr::walk(ct,function(v) lines(v$x,v$y,col="red"))
#Contours of a pixel set
px <- boats.gs > .8
plot(boats.gs)
ct <- contours(px)
#Highlight pixset
purrr::walk(ct,function(v) lines(v$x,v$y,col="red"))
}
\author{
Simon Barthelme
}
\seealso{
highlight
}

