% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{interp}
\alias{interp}
\title{Interpolate image values}
\usage{
interp(im, locations, cubic = FALSE, extrapolate = TRUE)
}
\arguments{
\item{im}{the image (class cimg)}

\item{locations}{a data.frame}

\item{cubic}{if TRUE, use cubic interpolation. If FALSE, use linear (default FALSE)}

\item{extrapolate}{allow extrapolation (to values outside the image)}
}
\description{
This function provides 2D and 3D (linear or cubic) interpolation for pixel values.
Locations need to be provided as a data.frame with variables x,y,z, and c (the last two are optional).
}
\examples{

loc <- data.frame(x=runif(10,1,width(boats)),y=runif(10,1,height(boats))) #Ten random locations
interp(boats,loc)
}

