% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/cimg_class.R
\name{pixel.index}
\alias{pixel.index}
\title{Linear index in internal vector from pixel coordinates}
\usage{
pixel.index(im, coords)
}
\arguments{
\item{im}{an image}

\item{coords}{a data.frame with values x,y,z (optional), c (optional)}
}
\value{
a vector of indices (NA if the indices are invalid)
}
\description{
Pixels are stored linearly in (x,y,z,c) order. This function computes the vector index of a pixel given its coordinates
}
\examples{
im <- as.cimg(function(x,y) x+y,100,100)
px <- pixel.index(im,data.frame(x=c(3,3),y=c(1,2)))
im[px] #Values should be 3+1=4, 3+2=5
}
\author{
Simon Barthelme
}

