% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{img_read}
\alias{img_read}
\title{Read bitmap image (bmp, jpg, png, tiff)}
\usage{
img_read(path, ...)
}
\arguments{
\item{path}{Path to the image file.}

\item{...}{Additional parameters that are passed to
\code{\link[readbitmap]{read.bitmap}} and the underlying image reader
packages.}
}
\value{
Objects returned by \code{\link[bmp]{read.bmp}},
  \code{\link[jpeg]{readJPEG}}, \code{\link[png]{readPNG}}, or
  \code{\link[tiff]{readTIFF}}. See their documentation for details.
}
\description{
Wrapper for readbitmap's \code{\link[readbitmap]{read.bitmap}} function. The
function currently allows reading in images in \code{bmp}, \code{jpg} /
\code{jpeg}, \code{png}, or \code{tif} / \code{tiff} format.
}
\details{
For details, see the \code{\link[readbitmap]{read.bitmap}}
  documentation.
}
\examples{
## Example image with high vertical symmetry: rails
rails <- img_read(system.file("example_images", "rails.jpg", package = "imagefluency"))
}
\seealso{
\code{\link[readbitmap]{read.bitmap}}, \code{\link[bmp]{read.bmp}},
  \code{\link[jpeg]{readJPEG}}, \code{\link[png]{readPNG}},
  \code{\link[tiff]{readTIFF}}
}
