% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_line_graph}
\alias{make_line_graph}
\alias{line.graph}
\alias{line_graph}
\title{Line graph of a graph}
\usage{
make_line_graph(graph)

line_graph(...)
}
\arguments{
\item{graph}{The input graph, it can be directed or undirected.}

\item{...}{Passed to \code{make_line_graph()}.}
}
\value{
A new graph object.
}
\description{
This function calculates the line graph of another graph.
}
\details{
The line graph \code{L(G)} of a \code{G} undirected graph is defined as
follows. \code{L(G)} has one vertex for each edge in \code{G} and two
vertices in \code{L(G)} are connected by an edge if their corresponding
edges share an end point.

The line graph \code{L(G)} of a \code{G} directed graph is slightly
different, \code{L(G)} has one vertex for each edge in \code{G} and two
vertices in \code{L(G)} are connected by a directed edge if the target of
the first vertex's corresponding edge is the same as the source of the
second vertex's corresponding edge.
}
\examples{

# generate the first De-Bruijn graphs
g <- make_full_graph(2, directed = TRUE, loops = TRUE)
make_line_graph(g)
make_line_graph(make_line_graph(g))
make_line_graph(make_line_graph(make_line_graph(g)))

}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}, the first version of
the C code was written by Vincent Matossian.
}
\keyword{graphs}
