% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrg.R
\name{print.igraphHRGConsensus}
\alias{print.igraphHRGConsensus}
\title{Print a hierarchical random graph consensus tree to the screen}
\usage{
\method{print}{igraphHRGConsensus}(x, ...)
}
\arguments{
\item{x}{\code{igraphHRGConsensus} object to print.}

\item{...}{Ignored.}
}
\value{
The input object, invisibly, to allow method chaining.
}
\description{
Consensus dendrograms (\code{igraphHRGConsensus} objects) are printed
simply by listing the children of each internal node of the
dendrogram: \preformatted{HRG consensus tree:
g1 -> 11 12 13 14 15 16 17 18 19 20
g2 -> 1  2  3  4  5  6  7  8  9  10
g3 -> g1 g2}
The root of the dendrogram is \code{g3} (because it has no incoming
edges), and it has two subgroups, \code{g1} and \code{g2}.
}
\seealso{
Other hierarchical random graph functions: 
\code{\link{consensus_tree}()},
\code{\link{fit_hrg}()},
\code{\link{hrg-methods}},
\code{\link{hrg_tree}()},
\code{\link{hrg}()},
\code{\link{predict_edges}()},
\code{\link{print.igraphHRG}()},
\code{\link{sample_hrg}()}
}
\concept{hierarchical random graph functions}
