% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\encoding{UTF-8}
\name{isrow}
\alias{isrow}
\title{Row Vector (GNU Octave/MATLAB compatible)}
\usage{
isrow(x)
}
\arguments{
\item{x}{An array (array, matrix, vector)}
}
\value{
"Return true if x is a row vector. A row vector is a 2-D array for
  which size (x) returns [1, N] with non-negative N." Source: Eaton page 68.
}
\description{
Test for row vector that is compatible with GNU Octave/MATLAB.
}
\examples{

library(iemisc)

# Examples

xx <- ramify::mat("1, 2"); xx

isrow(xx)








}
\references{
John W. Eaton, David Bateman, Søren Hauberg, and Rik Wehbring (November 2022). \emph{GNU Octave: A high-level interactive language for numerical computations: Edition 7 for Octave version 7.3.0}. \url{https://docs.octave.org/octave.pdf}. Page 68.
}
\seealso{
\code{\link{iscolumn}}
}
\author{
Irucka Embry, Rik Wehbring (GNU Octave), Colin B. Macdonald (OctSymPy)
}
