% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Manningtrap.R
\encoding{UTF-8}
\name{Manningtrap_critical}
\alias{Manningtrap_critical}
\title{Trapezoidal cross-section for the Gauckler-Manning-Strickler equation (critical parameters)}
\usage{
Manningtrap_critical(
  Q = NULL,
  n = NULL,
  m = NULL,
  m1 = NULL,
  m2 = NULL,
  Sf = NULL,
  y = NULL,
  b = NULL,
  T = NULL,
  units = c("SI", "Eng"),
  type = c("symmetrical", "non-symmetrical"),
  critical = c("approximate", "accurate"),
  output = c("list", "data.table")
)
}
\arguments{
\item{Q}{numeric vector that contains the discharge value {m^3/s or ft^3/s},
if known.}

\item{n}{numeric vector that contains the Manning's roughness coefficient n,
if known.}

\item{m}{numeric vector that contains the symmetric "cross-sectional side slope
of m:V (horizontal:vertical)", if known.}

\item{m1}{numeric vector that contains the non-symmetric "cross-sectional side
slope of m1:V (horizontal:vertical)", if known.}

\item{m2}{numeric vector that contains the non-symmetric "cross-sectional side
slope of m2:V (horizontal:vertical)", if known.}

\item{Sf}{numeric vector that contains the bed slope (m/m or ft/ft),
if known.}

\item{y}{numeric vector that contains the flow depth (m or ft), if known.}

\item{b}{numeric vector that contains the bottom width, if known.}

\item{T}{numeric vector that contains the temperature (degrees C or degrees
Fahrenheit), if known.}

\item{units}{character vector that contains the system of units {options are
\code{SI} for International System of Units or \code{Eng} for English units
(United States Customary System in the United States and Imperial Units in
the United Kingdom)}}

\item{type}{character vector that contains the type of trapezoid (symmetrical
or non-symmetrical). The symmetrical trapezoid uses \code{m} while the non-
symmetrical trapezoid uses \code{m1} and \code{m2}.}

\item{critical}{character vector that contains the type of critical parameters
calculations (\code{approximate} or \code{accurate}). The accurate calculation
provides parameters where the Froude number is 1. The approximate calculation
calculates the values without having the Froude number return 1.}

\item{output}{character vector that contains the output type, either it will be
a \code{\link[base]{list}} or \code{\link[data.table]{data.table}}. The list is
the easiest to obtain a singular value.}
}
\value{
the missing parameters (Q, n, b, m, m1, m2, Sf, or y) & V (velocity),
  A (area), P (wetted perimeters), R (hydraulic radius), B (top width), D
  (hydraulic depth), w (Wetted Length), w1 (Wetted Length for a
  non-symmetric trapezoid), w2 (Wetted Length for a non-symmetric trapezoid),
  Z (Section Factor), E (Specific Energy), K (conveyance), Vel_Head (Velocity
  Head), Re (Reynolds number), Fr (Froude number), taud (maximum shear
  stress), tau0 (average shear stress), yc (critical depth), Ac (critical
  area), Pc (critical wetted perimeters), Bc (critical top width), Rc (critical
  hydraulic radius), Dc (critical hydraulic depth), Vc (critical velocity), Qc
  (critical discharge), Sfc (critical slope), Frc (critical Froude number), Zc
  (critical Section Factor), Ec (critical Specific Energy) as a \code{\link[base]{list}}.
  Alternatively, the Flow depth (y), Flow area (A), Wetted Perimeters (P),
  Top Width (B), Bottom width (b), Hydraulic Radius (R), Hydraulic Depth (D),
  Flow Mean Velocity (V), Flow Discharge (Q), Manning's roughness coefficient
  (n), Slope (Sf), Temperature, Absolute Temperature, Saturated Liquid
  Density, Absolute or Dynamic Viscosity, Kinematic Viscosity, Froude number
  (Fr), Reynolds number (Re), symmetric side slope (m), non-symmetric side
  slope (m1), non-symmetric side slope (m2), Wetted Length (w), Wetted Length
  for a non-symmetric trapezoid (w1), Wetted Length for a non-symmetric
  trapezoid (w2), Section Factor (Z), conveyance (K), Specific Energy (E),
  Velocity Head (Vel_Head), Maximum Shear Stress (taud), Average Shear Stress
  (tau0) along with the associated units can be returned in a \code{\link[data.table]{data.table}}.
  Both the normal and the critical values (where present) are returned in the
  table.
}
\description{
This function solves for one missing variable in the Gauckler-Manning-
Strickler equation for a trapezoidal cross-section and uniform flow. The
\code{\link[stats]{uniroot}} function is used to obtain the missing parameters.
This function provides both normal and critical parameters values.
}
\examples{

# Example 1

library(iemisc)
# Exercise 4.1 from Sturm (page 153)

uuc <- Manningtrap_critical(Q = 3000, b = 40, m = 3, Sf = 0.002, n = 0.025,
units = "Eng", type = "symmetrical", critical = "accurate", output = "list")
# Q = 3000 cfs, b = 40 ft, m = 3, Sf = 0.002 ft/ft, n = 0.025,
# units = English units
# This will solve for y since it is missing and y will be in ft

uuc$y # only returns y

uuc # returns all results



# Example 2

install.load::load_package("iemisc", "iemiscdata")

# Practice Problem 14.19 from Mott (page 392)
# See nchannel in iemiscdata for the Manning's n table that the following
# example uses
# Use the minimum Manning's n value for 1) Natural streams - minor streams
# (top width at floodstage < 100 ft) Lined or Constructed Channels,
# 3) Concrete and 4) float finish.

data(nchannel)

nlocationc <- grep("float finish",
nchannel$"Type of Channel and Description")

nc <- nchannel[nlocationc, 3][1] # 3 for column 3 - Normal n

ttc <- Manningtrap_critical(y = 1.5, b = 3, m = 3/2, Sf = 0.1/100, n = nc,
units = "SI", type = "symmetrical", critical = "accurate", output = "list")
# y = 1.5 m, b = 3 m, m = 3/2, Sf = 0.1/100 m/m, n = 0.023, units = SI
# units
# This will solve for Q since it is missing and Q will be in m^3/s

ttc$Q # only returns Q

ttc # returns all results






}
\author{
Irucka Embry
}
