% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\encoding{UTF-8}
\name{size}
\alias{size}
\title{Size of R objects (GNU Octave/MATLAB compatible)}
\source{
pracma size function definition - R package pracma created and maintained by Hans Werner Borchers. See \code{\link[pracma]{size}}.
}
\usage{
size(x, k)
}
\arguments{
\item{x}{An R object (array, vector, or matrix)}

\item{k}{integer specifying a particular dimension}
}
\value{
"Return the number of rows and columns of the object x as a numeric
  vector. If given a second argument, \code{size} will return the size of the
  corresponding dimension." Source: Eaton.
}
\description{
Provides the dimensions of R objects in a manner compatible with
GNU Octave/MATLAB. This function is the same as \code{\link[pracma]{size}}, except this
\code{size} can find the size of character vectors too. Some documentation from
\code{\link[pracma]{size}}.
}
\examples{
library("iemisc")
library(gsubfn)


# Examples from GNU Octave size
object1 <- matrix(c(1, 2, 3, 4, 5, 6), nrow = 3, ncol = 2, byrow = TRUE)
size(object1)


list[nr, nc] <- size(matrix(c(1, 2, 3, 4, 5, 6), nrow = 3, ncol = 2,
                byrow = TRUE))

size(matrix(c(1, 2, 3, 4, 5, 6), nrow = 3, ncol = 2, byrow = TRUE), 2)

# Examples from pracma size
size(1:8)

size(matrix(1:8, 2, 4))

size(matrix(1:8, 2, 4), 2)

size(matrix(1:8, 2, 4), 3)

ss <- "object"
size(ss)


\dontrun{
# check against GNU Octave
library(RcppOctave) # requires Octave (>= 3.2.4) and its development files
o_source(text = "
\\% Examples from GNU Octave size
object1 = [1, 2; 3, 4; 5, 6];
size(object1)

[nr, nc] = size([1, 2; 3, 4; 5, 6])

size([1, 2; 3, 4; 5, 6], 2)

\\% Examples from pracma size
size(1:8)

object2 = [1 3 5 7; 2 4 6 8];

size(object2)

size(object2, 2)

size(object2, 3)

ss = 'object';
size(ss)
")
}


}
\references{
John W. Eaton, David Bateman, and Søren Hauberg (2009). \emph{GNU Octave version 3.0.1 manual: a high-level interactive language for numerical computations}. CreateSpace Independent Publishing Platform. ISBN 1441413006, URL \url{http://www.gnu.org/software/octave/doc/interpreter/}. Page 42.
}
\seealso{
\code{\link[base]{dim}}, \code{\link[pracma]{size}}
}
\author{
Hans Werner Borchers (pracma size), Irucka Embry
}
