% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mae.R
\encoding{UTF-8}
\name{mae}
\alias{mae}
\title{Mean-absolute error (MAE)}
\usage{
mae(predicted, observed, na.rm = FALSE)
}
\arguments{
\item{predicted}{numeric vector that contains the model predicted
data points (1st parameter)}

\item{observed}{numeric vector that contains the observed data
points (2nd parameter)}

\item{na.rm}{logical vector that determines whether the missing
values should be removed or not.}
}
\value{
mean-absolute error (MAE) as a numeric vector using the same
   units as the given variables. The default choice is that any NA values
   will be kept (\code{na.rm = FALSE}). This can be changed by
 specifying \code{na.rm = TRUE}, such as \code{mae(pre, obs, na.rm = TRUE)}.
}
\description{
This function computes the mean-absolute error (MAE).
}
\details{
(MAE) is expressed as

\deqn{n^{-1} \sum \limits_{i=1}^n{ \left| P_i - O_i \right|}}

\describe{
\item{\emph{n}}{the number of observations}
\item{\emph{P}}{the "model estimates or predictions"}
\item{\emph{O}}{the "thought-to-be reliable and pairwise matched
  observations"}
}

MAE is fully discussed in the Willmott reference, including a
  comparison to root mean square error (RMSE).
}
\examples{

library("ie2misc")

obs <- 1:10 # observed
pre <- 2:11 # predicted
mae(pre, obs)


library("rando")

set_n(100) # makes the example reproducible
obs1 <- r_norm(.seed = 103) # observed
pre1 <- r_norm(.seed = 102) # predicted


# using the vectors pre1 and obs1
mae(pre1, obs1)


# using a matrix of the numeric vectors pre1 and obs1
mat1 <- matrix(data = c(obs1, pre1), nrow = length(pre1), ncol = 2,
   byrow = FALSE, dimnames = list(c(rep("", length(pre1))),
   c("Predicted", "Observed")))
mae(mat1[, 2], mat1[, 1])

# mat1[, 1] # observed values from column 1 of mat1
# mat1[, 2] # predicted values from column 2 of mat1


# using a data.frame of the numeric vectors pre1 and obs1
df1 <- data.frame(obs1, pre1)
mae(df1[, 2], df1[, 1])

# df1[, 1] # observed values from column 1 of df1
# df1[, 2] # predicted values from column 2 of df1


library("data.table")

# using a data.table of the numeric vectors pre1 and obs1
df2 <- data.table(obs1, pre1)
mae(df2[, 2, with = FALSE][[1]], df2[, 1, with = FALSE][[1]])

# df2[, 1, with = FALSE][[1]] # observed values from column 1 of df2
# df2[, 2, with = FALSE][[1]] # predicted values from column 2 of df2


}
\references{
Cort J. Willmott and Kenji Matsuura, "Advantages of the mean-absolute error (MAE) over the root mean square error (RMSE) in assessing average model performance", \emph{Climate Research}, Vol. 30: 79-82, 2005, \url{https://web.archive.org/web/20230119121852/climate.geog.udel.edu/~climate/publication_html/Pdf/WM_CR_05.pdf}. Retrieved thanks to the Internet Archive: Wayback Machine
}
\seealso{
\code{\link{mape}} for mean absolute percent error (MAPE), \code{\link{madstat}} for
 mean-absolute deviation (MAD), \code{\link{dr}} for "index of agreement (dr)", \code{\link{vnse}}
 for Nash-Sutcliffe model efficiency (NSE), and \code{\link{rmse}} for
 root mean square error (RMSE).
}
