% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymmetry.R
\name{asymmetry}
\alias{asymmetry}
\title{Function to calculate karyotype asymmetry A and A2}
\usage{
asymmetry(dfChrSize)
}
\arguments{
\item{dfChrSize}{name of dataframe}
}
\value{
list
}
\description{
This function reads a dataframe  with columns:
\code{shortArmSize} and \code{longArmSize}

If several species present, use
column \code{OTU}.

It returns a list with the A and A2 indices

\deqn{A_{2} = \frac{sCL}{xCL}}{%
     A2 = sCL / xCL}

(s = std dev, CL = chr. length, x = mean)

related to:
\deqn{CV_{CL} = A_{2} * 100}{%
      CVCL = A2 * 100}

(CV = coeff. var.)

A: Watanabe et al. (1999) asymmetry of karyotype ranging from 0
(symmetric) to 1 (asymmetric)
}
\examples{
data(dfOfChrSize)
asymmetry(dfOfChrSize)
}
\references{
Watanabe K, Yahara T, Denda T, Kosuge K. (1999) Chromosomal
evolution in the genus Brachyscome (Asteraceae, Astereae): Statistical tests
regarding correlation between changes in karyotype and habit using
phylogenetic information. Journal of Plant Research 112: 145-161.
10.1007/PL00013869

A2: Romero-Zarco. 1986. A New Method for Estimating Karyotype
Asymmetry. Taxon Vol. 35, No. 3  pp. 526-530
}
\keyword{arm}
\keyword{dataframe}
\keyword{size}
