% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_data.R
\name{imData}
\alias{imData}
\title{Create data for IDEM analysis}
\usage{
imData(
  data,
  trt = NULL,
  surv = NULL,
  outcome = NULL,
  endfml = NULL,
  y0 = NULL,
  cov = NULL,
  duration = 9999,
  bounds = NULL,
  trt.label = NULL,
  unitTime = "days",
  err.terminate = TRUE,
  ...
)
}
\arguments{
\item{data}{Original dataset}

\item{trt}{Variable name for the Control (0) and Intervention (1) treatment
assignments in the dataset}

\item{surv}{Variable name for the survival (time to event) variable in the
dataset}

\item{outcome}{Chronologically ordered vector of variable names for clinical
outcomes in the dataset excluding baseline}

\item{endfml}{\code{R} expression indicating the user-specified final outcome of
interest. This is the function for \eqn{Z} of one or more of \eqn{Y_k}'s}

\item{y0}{Variable name of the baseline clinical outcome}

\item{cov}{Vector of variable names for the covariates used in the imputation
procedure for missing clinical outcomes}

\item{duration}{Length of the study. This is the time at which subjects' are
assumed to be censored}

\item{bounds}{Numeric vector of lower and upper bounds for subjects' imputed
clinical outcomes}

\item{trt.label}{label of the treatment arms}

\item{unitTime}{Unit of time measurement for survival and function outcome time points}

\item{err.terminate}{When there is error in the specification, the program
should be stopped with an error message if err.terminate is true.
Otherwise, the error message will be returned and the program will continue.}

\item{...}{Additional specifications}
}
\value{
When the specifications are correct, a class \code{IDEMDATA} list will be
  returned. The list contains
  \describe{
     \item{data}{Original dataset}
     \item{lst.var}{List of the specifications}}
}
\description{
Create a class \code{IDEMDATA} object for IDEM analysis
}
\details{
When there are errors in the specification, i.e. \code{trt} is not a column
of \code{data}, a class \code{IDEMERROR} object will be returned. The
detailed errors can be checked by calling \code{print} of the
\code{IDEMERROR} object.
}
\examples{
rst.data <- imData(abc, trt="TRT", surv="SURV", outcome=c("Y1","Y2"),
                   y0=NULL, endfml="Y2",
                   trt.label = c("UC+SBT", "SAT+SBT"),
                   cov=c("AGE"), duration=365, bounds=c(0,100));

}
