% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc_merge.R
\name{nc_merge}
\alias{nc_merge}
\title{Merging Network Canvas CSV Files (\code{nc_merge})}
\usage{
nc_merge(path, export_path)
}
\arguments{
\item{path}{A character value indicating the directory in which Network Canvas CSVs are located. \code{nc_read} will read in all CSV files located in this directory and process them.}

\item{export_path}{A character value indicating the directory to which merged CSV files should be exported. This should not be the same directory as \code{path}, and this function will return an error if it detects that \code{path} and \code{export_path} are equivalent.}
}
\value{
\code{nc_merge} always writes two CSV files to the directory specified in \code{export_path}: an ego list and an alters list. If CSV files containing alter-alter ties are detected, it also writes a third merged CSV of these ties.
}
\description{
The \code{nc_merge} function combines CSV files exported from \href{https://networkcanvas.com/}{Network Canvas}, a popular tool for egocentric data capture. It is designed to address issues that may be encountered by \code{nc_read} when Network Canvas exports separate CSV files for individual responses.
}
