% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{id_plot_legis_var}
\alias{id_plot_legis_var}
\title{Plot Legislator/Person Over-time Variances}
\usage{
id_plot_legis_var(object, return_data = FALSE, include = NULL,
  high_limit = 0.95, low_limit = 0.05, text_size_label = 2,
  text_size_group = 2.5, point_size = 1, hjust_length = -0.7,
  person_labels = TRUE, group_labels = F, person_ci_alpha = 0.1,
  group_color = TRUE, ...)
}
\arguments{
\item{object}{A fitted \code{idealstan} object}

\item{return_data}{If true, the calculated legislator/bill data is returned along with the plot in a list}

\item{include}{Specify a list of person/legislator IDs to include in the plot (all others excluded)}

\item{high_limit}{The quantile (number between 0 and 1) for the high end of posterior uncertainty to show in plot}

\item{low_limit}{The quantile (number between 0 and 1) for the low end of posterior uncertainty to show in plot}

\item{text_size_label}{ggplot2 text size for legislator labels}

\item{text_size_group}{ggplot2 text size for group text used for points}

\item{point_size}{If \code{person_labels} and \code{group_labels} are set to \code{FALSE}, controls the size of the points plotted.}

\item{hjust_length}{horizontal adjustment of the legislator labels}

\item{person_labels}{if \code{TRUE}, use the person_id column to plot labels for the person (legislator) ideal points}

\item{group_labels}{if \code{TRUE}, use the group column to plot text markers for the group (parties) from the person/legislator data}

\item{person_ci_alpha}{The transparency level of the dot plot and confidence bars for the person ideal points}

\item{group_color}{If \code{TRUE}, give each group/bloc a different color}

\item{...}{Other options passed on to plotting function, currently ignored}
}
\description{
This function can be used on a fitted \code{idealstan} object to plot the over-time variances 
(average rates of change in ideal points) for all the persons/legislators in the model.
}
\details{
This function will plot the person/legislator over-time variances as a vertical
dot plot with associated high-density posterior interval (can be changed 
with \code{high_limit} and \code{low_limit} options).
}
\examples{

# To demonstrate, we load the 114th Senate data and fit a time-varying model

data('senate114_fit')

\dontrun{
senate_data <- id_make(senate114,outcome = 'cast_code',
person_id = 'bioname',
item_id = 'rollnumber',
group_id= 'party_code',
time_id='date',
miss_val='Absent')

 senate114_time_fit <- id_estimate(senate_data,
 model_type = 2,
 use_vb = T,
 fixtype='vb_partial',
 vary_ideal_pts='random_walk',
 restrict_ind_high = "WARREN, Elizabeth",
 restrict_ind_low="BARRASSO, John A.",
 seed=84520)
# We plot the variances for all the Senators

id_plot_legis_var(senate114_fit)
}
}
