% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmaPA.R
\name{sigmaPA}
\alias{sigmaPA}
\title{Sigma from PA Reference Points}
\usage{
sigmaPA(lim, pa)
}
\arguments{
\item{lim}{the value of the limit reference point, e.g., Blim or Flim.}

\item{pa}{the value of the PA reference point, e.g., Bpa or Fpa.}
}
\value{
Implicit value of sigma.
}
\description{
Calculate the implicit sigma that was used to calculate PA reference points
from limit reference points (Xpa from Xlim).
}
\details{
The order of the parameters does not matter, so \code{sigmaPA(Fpa, Flim)} and
\code{sigmaPA(Flim, Fpa)} are equivalent.
}
\note{
Useful for reviewing PA reference points, when the advice sheet provides the
value of Xlim and Xpa but not the value of sigma.

The inference is based on the following relationships:

\deqn{B_\mathrm{pa} = B_\mathrm{lim} \exp(1.645\sigma_B)}{
      Bpa = Blim * exp(1.645*sigmaB)}

\deqn{F_\mathrm{pa} = F_\mathrm{lim} \exp(-1.645\sigma_F)}{
      Fpa = Flim * exp(-1.645*sigmaF)}
}
\examples{
sigmaPA(100, 120)

}
\seealso{
\code{\link{sigmaCI}} calculates the implicit sigma from a confidence
interval.

\code{\link{Bpa}} and \code{\link{Fpa}} calculate those reference points from
the limit reference points, based on a given sigma.

\code{\link{icesAdvice-package}} gives an overview of the package.
}
\author{
Arni Magnusson.
}
