% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DLS3.2.R
\name{DLS3.2}
\alias{DLS3.2}
\title{DLS Method 3.2}
\usage{
DLS3.2(lastadvice, index, prebuffer = FALSE, i1 = head(tail(index, 5), 3),
  i2 = tail(index, 2))
}
\arguments{
\item{lastadvice}{last catch advice given for this stock.}

\item{index}{survey index series.}

\item{prebuffer}{whether to apply a \eqn{-20\%} precautionary buffer.}

\item{i1}{survey index values reflecting previous stock size.}

\item{i2}{survey index values reflecting current stock size.}
}
\value{
A list containing the resulting \code{advice} and other elements showing
intermediate steps in the calculation.
}
\description{
Evaluate ICES method 3.2 for data-limited stocks (DLS).
}
\details{
In the simplest case, only \code{lastadvice} and \code{index} are required.
The reference vectors \code{i1} and \code{i2} will then be evaluated
automatically:

\deqn{i1 = (I_{n-4}, I_{n-3}, I_{n-2})}
\deqn{i2 = (I_{n-1}, I_{n})}

To handle unusual cases, the user can specify \code{i1} and \code{i2}
manually, in which case the \code{index} vector is ignored. This can be
useful to specify reference periods that are different from the default, or
to work around \code{NA} values in the survey index. Missing values are not
permitted in the reference vectors \code{i1} and \code{i2}.
}
\note{
See the ICES (2012) guidance report for more information.
}
\examples{
# Three hypothetical surveys
survey <- data.frame(year=2001:2010, randu[1:10,])

DLS3.2(1000, survey$x)

DLS3.2(1000, survey$y)
DLS3.2(1000, survey$y, prebuffer=TRUE)

DLS3.2(1000, survey$z)
DLS3.2(1000, i1=survey$z[6:9], i2=survey$z[10])

}
\author{
Anne Cooper and Arni Magnusson.
}
\references{
ICES. 2012. ICES DLS guidance report: ICES implementation of advice for
data-limited stocks in 2012 in its 2012 advice. \cite{ICES CM 2012/ACOM:68.}
}
\seealso{
\code{\link{icesAdvice-package}} gives an overview of the package.
}

