% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{icd9FilterPoa}
\alias{icd9FilterPoa}
\alias{icd9FilterPoaNo}
\alias{icd9FilterPoaNotNo}
\alias{icd9FilterPoaNotYes}
\alias{icd9FilterPoaYes}
\title{Filters data frame based on present-on-arrival flag}
\usage{
icd9FilterPoa(icd9df, poaField = "poa", poa = icd9PoaChoices)

icd9FilterPoaYes(icd9df, poaField = "poa")

icd9FilterPoaNo(icd9df, poaField = "poa")

icd9FilterPoaNotNo(icd9df, poaField = "poa")

icd9FilterPoaNotYes(icd9df, poaField = "poa")
}
\arguments{
\item{icd9df}{data frame containing columns for visitId (which is the feault
name), icd9 (default for the icd9 code), and  maybe also a POA flag.}

\item{poaField}{The name of column in the data frame which contains the
Present On Arrival flag. The flag itself is a single character, typically
one of "Y", "N", "E", "X", "U" or empty. The poaField is a character vector
of length one.}

\item{poa}{single character value, being one of \code{poaChoices} whether to
account for co-morbidities flagged as present-on-arrival. This is not a
simple binary, since many codes are exempt, unspecified, or unknown.
\code{poaField} gives the choices: yes, not no, no, not yes. The
intermediate codes, such as "exempt", "unknown" and \code{NA} mean that
"yes" is not the same as "not no."}
}
\description{
Present On Arrival (POA) is not a simple flag, since many codes
  are exempt, unspecified, or unknown. Therefore, two options are given: get
  all the comorbidities where the POA flag was definitely -ve, coded as "N"
  or definitely +ve and coded as "Y". Negating one set won't give the other
  set unless all codes were either Y or N. #describeIn icd9Comorbid
}
\section{Functions}{
\itemize{
\item \code{icd9FilterPoaYes}: Select rows where Present-on-Arrival flag is
explicitly "Yes."

\item \code{icd9FilterPoaNo}: Select rows where Present-on-Arrival flag is
explicitly "No."

\item \code{icd9FilterPoaNotNo}: Select rows where Present-on-Arrival flag is
anything but "No." This includes unknown, exempt, other codes, and of
course all those marked "Yes."

\item \code{icd9FilterPoaNotYes}: Select rows where Present-on-Arrival flag is
anything byt "Yes." This would group exempt, unknown and other codes under
"Not POA" which is unlikely to be a good choice, since exempt codes, of
which there are a quite large number, tend to describe chronic or
out-of-hospital characteristics.
}}
\examples{
\dontrun{
# using magrittr is beautiful:
library("magrittr", quietly = TRUE, warn.conflicts = FALSE)
myData <- data.frame(
  visitId = c("v1", "v2", "v3", "v4"),
  diag = c("39891", "39790", "41791", "4401"),
  poa = c("Y", "N", NA, "Y"),
  stringsAsFactors = FALSE
)
myData \%>\% icd9FilterPoaNotNo() \%>\% icd9ComorbidAhrq
# can fill out named fields also:
myData \%>\% icd9FilterPoaYes(poaField="poa") \%>\%
  icd9ComorbidAhrq(icd9Field = "diag", visitId = "visitId", isShort = TRUE)
# can call the core icd9Comorbid function with an arbitrary mapping
myData \%>\%
icd9FilterPoaYes() \%>\%
icd9Comorbid(icd9Field = "diag", visitId = "visitId",
  icd9Mapping = quanElixComorbid,
 isShortMapping = TRUE)
}
}

