% Generated by roxygen2 (4.0.1): do not edit by hand
\name{stopIfInvalidIcd9}
\alias{stopIfInvalidIcd9}
\alias{warnIfInvalidIcd9}
\title{warn or stop with invalid ICD-9 codes}
\usage{
stopIfInvalidIcd9(icd9, short, callingFunction = "")

warnIfInvalidIcd9(icd9, short, callingFunction = "")
}
\arguments{
\item{icd9}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{short}{single logical value which determines whether the ICD-9 code provided is in short (TRUE) or decimal (FALSE) form.}

\item{callingFunction}{not implemented: ideally look at call stack and
indicate who called here.}
}
\description{
warn or stop with invalid ICD-9 codes
}
\seealso{
Other ICD9 validation: \code{\link{icd9ValidDecimal}},
  \code{\link{icd9ValidDecimalE}},
  \code{\link{icd9ValidDecimalE}},
  \code{\link{icd9ValidDecimalN}},
  \code{\link{icd9ValidDecimalN}},
  \code{\link{icd9ValidDecimalV}},
  \code{\link{icd9ValidDecimalV}};
  \code{\link{icd9ValidShort}},
  \code{\link{icd9ValidShortE}},
  \code{\link{icd9ValidShortE}},
  \code{\link{icd9ValidShortN}},
  \code{\link{icd9ValidShortN}},
  \code{\link{icd9ValidShortV}},
  \code{\link{icd9ValidShortV}}
}
\keyword{error}

