% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_data_raw.R
\name{unzip_to_data_raw}
\alias{unzip_to_data_raw}
\alias{download_to_data_raw}
\title{Unzip file to raw data directory}
\usage{
unzip_to_data_raw(url, file_name, force = FALSE, verbose = FALSE,
  offline = TRUE, data_raw_path = get_raw_data_dir(),
  save_name = file_name)

download_to_data_raw(url, file_name = regmatches(url, regexpr("[^/]*$",
  url)), offline = TRUE, data_raw_path = get_raw_data_dir())
}
\arguments{
\item{url}{URL of a zip file}

\item{file_name}{file name of a single file in that zip}

\item{force}{logical, if TRUE, then download even if already in the raw data
directory}

\item{verbose}{single logical value, defaults to \code{FALSE} in most functions.}

\item{offline}{single logical, if \code{TRUE} then don't pull the file from
internet, only return path and file name if the file already exists in the
raw data directory. This is helpful for testing without using the internet.}

\item{data_raw_path}{path where the raw directory is}
}
\value{
path of unzipped file in the raw data directory
}
\description{
Get a zip file from a URL, extract contents, and save file in the raw data
directory. If the file already exists there, it is only retrieved if
\code{force} is set to \code{TRUE}. If \code{offline} is \code{FALSE}, then
\code{NULL} is returned if the file isn't already downloaded.
}
\details{
The file name is changed to a conservative cross platform name using
\code{make.names}
}
\keyword{internal}
