% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real.R, R/z-deprecated.R
\name{is_defined}
\alias{is_defined}
\alias{is_defined.icd9}
\alias{is_defined.icd10cm}
\alias{is_defined.icd10}
\alias{is_defined.default}
\alias{icd_is_defined.default}
\alias{icd_is_defined.icd10}
\alias{icd_is_defined.icd10cm}
\alias{icd_is_defined.icd9}
\alias{icd_is_defined}
\title{Check whether ICD-9 codes exist}
\usage{
is_defined(x, short_code = guess_short(x), ...)

\method{is_defined}{icd9}(x, short_code = guess_short(x), billable = FALSE,
  ...)

\method{is_defined}{icd10cm}(x, short_code = guess_short(x),
  billable = FALSE, nomatch = 0L, ...)

\method{is_defined}{icd10}(x, short_code = guess_short(x), billable = FALSE,
  ...)

\method{is_defined}{default}(x, short_code = guess_short(x), ...)

icd_is_defined.default(...)

icd_is_defined.icd10(...)

icd_is_defined.icd10cm(...)

icd_is_defined.icd9(...)

icd_is_defined(...)
}
\arguments{
\item{x}{vector if ICD codes to test whether defined in certain ICD code list}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{...}{arguments passed on to other functions}

\item{billable}{single logical value, whether to limit return codes also by
whether they are billable, i.e. leaf nodes. This is really only designed
for use with ICD-9-CM, ICD-10-CM etc, since the WHO versions are not
designed for billing, but for public health and death reporting.}

\item{nomatch}{integer value, passed to \code{match} default is 0. Setting
this to \code{NA_integer_} would stop NA values being treated as undefined.}

\item{...}{arguments passed on to other functions}
}
\value{
logical vector
}
\description{
This is different from syntactic validity: it looks up codes in the canonical
lists published by the CMS.
}
\details{
The source data from CMS, and code to generate the R data are included in the
source tree of this package.
}
\section{Methods (by class)}{
\itemize{
\item \code{icd9}: Check whether ICD-9 code are defined. (ICD-9-CM by
default)

\item \code{icd10cm}: Same for ICD-10-CM

\item \code{icd10}: Same for ICD-10, temporarily using ICD-10-CM until
ICD-10 WHO is available in this package

\item \code{default}: default method which will guess the ICD version (9
vs 10, maybe WHO vs CM or other in the future) and dispatches again on that
type.
}}

\section{Deprecated function names}{
 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the prefix \code{icd::} instead, e.g., \code{icd::charlson}.
  Functions which specifically operate on either ICD-9 or ICD-10 codes or
  their sub-types will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.
}

\keyword{internal}
