% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_hcc.R
\name{icd_parse_cc_hierarchy}
\alias{icd_parse_cc_hierarchy}
\title{Import CMS HCC Rules}
\usage{
icd_parse_cc_hierarchy(save_data = FALSE)
}
\arguments{
\item{save_data}{logical whether to save the result in the source tree.
Defaults to \code{FALSE}.}

\item{condense}{Deprecated. The map is not condensed by default. If required,
it can reduced to a smaller set of codes using \code{icd_condense}.}
}
\value{
invisibly returns the list of vectors, where a co-morbidity name is
  associated with a character vector of ICD-9 codes.
}
\description{
The CMS Hierarchical Condition Categories are created by applying a series of
rules to the Condition Categories (CC) These rules were obtained from CMS
\href{https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Risk-Adjustors.html}{
Medicare Risk Adjustors}. Due to the complex file structure of the original
data (many nested zip files), they have been organized manually in the folder
\code{data/icd_hcc_rawdata/hierarchy}.
}
\details{
This function creates an \code{.RData} file containing rules for converting
CCs to HCC
}
\keyword{internal}
\keyword{manip}
