% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.R
\name{icd9_drop_leading_zeroes}
\alias{icd9_drop_leading_zeroes}
\alias{icd9_drop_leading_zeroes_major}
\title{drop zero padding from decimal ICD-9 code.}
\usage{
icd9_drop_leading_zeroes(x, short_code = icd_guess_short(x))

icd9_drop_leading_zeroes_major(major)
}
\arguments{
\item{icd9}{is a character vector or factor of ICD-9 codes. If fewer than five characters
is given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010".}
}
\value{
character vector of ICD-9 codes with extra zeroes dropped from major
  part
}
\description{
decimal form ICD-9 codes are not ambiguous if the leading zeroes are dropped.
Some short-form ICD-9 codes would not be ambiguous, e.g. "1" but many would
be problematic. This is the inverse of \code{icd9_add_leading_zeroes}.
}
\details{
Invalid codes have no guaranteed result, and may give NA, or a (possibly
valid) code in response.
}
\examples{
\dontrun{
library(microbenchmark)
x <- icd:::generate_random_decimal_icd9(1e6)
microbenchmark(
  x \%>\% icd:::as_char_no_warn \%>\%
  stringr::str_replace("[[:space:]]*([EeVv]?)(0*)([\\\\.[:digit:]]*)[[:space:]]*", "\\\\1\\\\3"),

  stringr::str_replace(icd:::as_char_no_warn(x),
              "[[:space:]]*([EeVv]?)(0*)([\\\\.[:digit:]]*)[[:space:]]*", "\\\\1\\\\3"),

  gsub("[[:space:]]*([EeVv]?)(0*)([\\\\.[:digit:]]*)[[:space:]]*", "\\\\1\\\\3", x),
  times = 1000
  )
}
}
\seealso{
Other ICD-9 convert: \code{\link{icd9PartsToShort}},
  \code{\link{icd9_chapters_to_map}},
  \code{\link{icd_long_to_wide}},
  \code{\link{icd_wide_to_long}}
}
\keyword{internal}
\keyword{manip}
