% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{icd9_parse_leaf_desc_ver}
\alias{icd9_parse_leaf_desc_ver}
\title{Read the ICD-9-CM description data as provided by the Center for Medicaid
Services (CMS).}
\usage{
icd9_parse_leaf_desc_ver(version = icd9cm_latest_edition(),
  save_data = TRUE, offline = TRUE)
}
\arguments{
\item{version}{character vector of length one containing the ICD-9 version,
e.g. \code{"32"} which is the default.}

\item{save_data}{single logical value, if \code{TRUE} will save the generated
data}

\item{offline}{single logical, if \code{TRUE} then don't pull the file from
internet, only return path and file name if the file already exists in
data-raw. This is helpful for testing without using the internet.}

\item{path}{Absolute path in which to save parsed data}
}
\value{
invisibly return the result
}
\description{
The full ICD-9 specification is in an RTF file, but CMS also distributes a
space-separated text file with just the definitions for 'defined', 'billable'
codes. Note that this canonical data doesn't specify non-diagnostic
higher-level codes, just the specific diagnostic 'child' codes.
}
\details{
The file can be pulled from the zip files on the CMS web site or from within
the package.
}
\examples{
\dontrun{
library(stringr)
library(microbenchmark)
# str_split is faster
x <- icd:::generate_random_decimal_icd9(10)
microbenchmark(strsplit(x, "\\\\."), str_split(x, "\\\\."))
# str_trim is faster with nothing to trim
microbenchmark(trim(x), str_trim(x))
}
}
\keyword{internal}

