topo.ic<-function(x,
			   ic,
			   coords=c("bosemi.32","egi.129","neuromag.306.mag",
						"neuromag.306.plan1","neuromag.306.plan2"), 
				  		# or a data frame with Cartesian coordinates
			   col="topo",
			   xlab="left to right",
			   ylab="back to front",
			   k=NULL,
			   bs="cr",
			   too.far=NULL, # or a numeric value
			   ...
){
	if(!"icac"%in%class(x))stop("object not of class \"icac\"\n")
	if(missing(x))stop("please supply an \"icac\" object\n")
	if(missing(ic))stop("please supply an independent component\n")
	if(missing(coords))stop("please supply a coordinate data frame\n")

	require(mgcv,quietly=TRUE)

	if(is.vector(coords[1])&&is.character(coords[1])){
		if(coords[1]=="biosemi.32"){
			if(is.null(k))k<-5
    		coords<-data.frame(x=c(-0.496189,-0.545830,-1.299041,-0.659023,
				-0.394923,-1.173172,-1.605703,-0.802851,-0.394923,-1.173172,
				-1.299041,-0.659023,0.000000,-0.545830,-0.496189,0.000000,
				0.496189,0.545830,0.659023,1.299041,1.173172,0.394923,0.802851,
				1.605703,1.173172,0.394923,0.659023,1.299041,0.545830,0.496189,
				0.000000,0.000000),y=c(1.527114,1.170536,0.943808,0.813825,
				0.394923,0.450338,-0.000000,-0.000000,-0.394923,-0.450338,
				-0.943808,-0.813825,-0.802851,-1.170536,-1.527114,-1.605703,
				-1.527114,-1.170536,-0.813825,-0.943808,-0.450338,-0.394923,
				0.000000,0.000000,0.450338,0.394923,0.813825,0.943808,1.170536,
				1.527114,0.802851,0.000000),Channel=c("Fp1","AF3","F7","F3",
				"FC1","FC5","T7","C3","CP1","CP5","P7","P3","Pz","PO3","O1",
				"Oz","O2","PO4","P4","P8","CP6","CP2","C4","T8","FC6","FC2",
				"F4","F8","AF4","Fp2","Fz","Cz"))
			if(is.null(too.far)){
				too.far<-0.115
			}
		}else if(coords[1]=="egi.129"){
			if(is.null(k))k<-11
			coords<-data.frame(ID=c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
				19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
				40,41,42,42,43,44,45,46,47,48,49,50,51,53,54,55,56,57,58,59,60,
				61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,
				82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,
				102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,
				118,119,120,121,122,123,124,125,126,127,128,129,130,131),
				Channel=c('E1','E2','E3','E4','E5','E6','E7','E8','E9','E10',
				'E11','E12','E13','E14','E15','E16','E17','E18','E19','E20',
				'E21','E22','E23','E24','E25','E26','E27','E28','E29','E30',
				'E31','E32','E33','E34','E35','E36','E37','E38','E39','E40',
				'E41','E42','E52','E43','E44','E45','E46','E47','E48','E49',
				'E50','E51','E53','E54','E55','E56','E57','E58','E59','E60',
				'E61','E62','E63','E64','E65','E66','E67','E68','E69','E70',
				'E71','E72','E73','E74','E75','E76','E77','E78','E79','E80',
				'E81','E82','E83','E84','E85','E86','E87','E88','E89','E90',
				'E91','E92','E93','E94','E95','E96','E97','E98','E99','E100',
				'E101','E102','E103','E104','E105','E106','E107','E108','E109',
				'E110','E111','E112','E113','E114','E115','E116','E117','E118',
				'E119','E120','E121','E122','E123','E124','E125','E126','E127',
				'E128','E129','COM','S/N'),x=c(4.5,3.1,2.25,1.1,0.6,0,
				-0.55,3.15,1.8,1.1,0,-0.6,-1,1.5,0,0,0,-1.1,-1.1,-1.55,-1.5,
				-1.8,-2.25,-2.1,-3.15,-3.1,-3.15,-2.9,-2.35,-1.65,-0.9,-4.5,
				-4.45,-3.95,-3.4,-2.75,-1.65,-5.75,-5.2,-4.45,-3.6,-2.5,-2.9,
				-6.75,-6.2,-5.35,-4.4,-3.4,-8,-7.25,-5,-4,-2,-1,0,-6.85,-5.85,
				-4.5,-3.15,-2.1,-1.1,0,-5.9,-4.6,-3.15,-1.9,-1.1,-4.25,-2.55,
				-1.55,-0.8,0,-2.2,-1.1,0,0.8,1.1,1.1,1,0.9,0,1.1,1.55,1.9,2.1,
				2,1.65,2.2,2.55,3.15,3.15,2.9,2.5,4.25,4.6,4.5,4,3.4,5.9,5.85,
				5,4.4,3.6,2.75,1.65,0.55,6.85,5.35,4.45,3.4,2.35,1,7.25,6.2,
				5.2,3.95,2.9,1.55,8,6.75,5.75,4.45,3.15,2.1,5.5,1.1,-1.1,-5.5,
				0,0,0),y=c(4.4,4.35,3.8,3.4,2.5,1.75,0.7,5.45,5.05,4.3,3.55,
				2.5,0.9,6.1,5.4,4.5,7.2,4.3,3.4,2.1,6.1,5.05,3.8,2.95,5.45,4.35,
				3.25,2.15,1.25,0.55,-0.4,4.4,3,2.05,1.3,0.1,-0.55,2.1,1.15,0.5,
				-0.05,-0.95,-2.15,2.25,1.25,-0.5,-0.95,-1.3,2.45,-0.025,-1.9,
				-2,-1.75,-1.5,-0.95,-2.25,-2.95,-3,-3.25,-2.95,-2.5,-2.65,-4.1,
				-4.35,-4.4,-4.05,-3.45,-5.85,-5.8,-5.15,-4.5,-3.6,-6.85,-6.25,
				-5.4,-4.5,-3.45,-2.5,-1.5,-0.4,-7.2,-6.25,-5.15,-4.05,-2.95,
				-1.75,-0.55,-6.85,-5.8,-4.4,-3.25,-2.15,-0.95,-5.85,-4.35,-3,
				-2,-1.3,-4.1,-2.95,-1.9,-0.95,-0.05,0.1,0.55,0.7,-2.25,-0.5,
				0.5,1.3,1.25,0.9,-0.025,1.25,1.15,2.05,2.15,2.1,2.45,2.25,2.1,
				3,3.25,2.95,4.8,8.2,8.2,4.8,0,-1.75,-8.4))
			if(is.null(too.far)){
				too.far<-0.055
			}

		}else if(coords[1]=="neuromag.306.mag"){
			coords<-data.frame(x=c(-67.416206,-53.602242,-62.018288,-74.582848,
				-50.595154,-38.599728,-41.41642,-53.280643,-33.790501,-32.014336,
				-21.679966,-43.684467,-26.99799,-15.084751,-15.930935,-28.824663,
				-21.861498,-9.506709,-8.616095,-21.240477,-8.782405,3.032724,
				-3.094766,-9.199021,-3.246834,9.314525,9.387173,-3.422897,
				3.037592,3.034455,15.50483,27.96731,27.254196,14.661931,3.032913,
				14.751018,15.123913,9.200539,21.014965,32.958527,34.757563,
				21.882982,39.958897,49.923473,38.014336,27.600079,44.599728,
				56.558392,59.420483,47.371586,59.704369,73.119286,80.438919,
				67.883209,-65.298943,-61.281609,-65.70282,-73.907913,-50.916454,
				-39.631779,-31.896103,-42.859089,-50.79604,-51.188797,-35.902962,
				-31.408134,-27.801163,-15.685101,-3.600111,-18.483526,-19.866816,
				-14.513481,-17.428471,-30.237587,-4.44193,10.357624,10.645295,
				-4.645079,2.947649,3.000001,14.918572,-8.987089,21.64146,
				33.786499,24.501518,9.641699,25.852789,36.078903,23.363274,
				20.32992,45.64481,56.812263,48.69418,37.896111,41.812634,
				57.171906,56.704624,37.320171,71.13736,79.822243,71.490112,
				67.220192),y=c(35.916687,40.989067,21.17697,10.595787,19.519251,
				20.043873,2.283216,-0.261772,49.930138,35.268585,31.368065,
				36.578434,18.107347,16.453575,2.414510,2.862587,57.939636,
				62.119865,51.80838,46.36343,40.647827,29.760933,17.200909,
				29.131405,4.193846,4.073887,-8.088106,-8.019942,63.507698,
				53.141838,62.155254,57.90871,46.389683,51.858044,42.169956,
				40.654079,29.148697,17.29562,16.412239,18.06213,2.727141,
				2.537710,49.88879,36.414738,35.268585,31.398149,20.043867,
				19.387651,-0.419475,2.283183,41.06303,36.343739,10.835863,
				21.062304,-2.207253,-22.907852,-37.652336,-14.918098,-17.812164,
				-13.820436,-28.078358,-33.676094,-56.582275,-41.557373,
				-55.779526,-69.949036,-11.268716,-10.119589,-19.690945,
				-24.350609,-38.35004,-53.855225,-64.875893,-45.94453,-31.808243,
				-31.789736,-43.790749,-43.744335,-56.389515,-67.862061,
				-76.941826,-76.928932,-10.079389,-11.16998,-24.449615,-19.706125,
				-38.37122,-45.97496,-64.865387,-53.88026,-13.675139,-17.901899,
				-33.77858,-28.078348,-55.800888,-41.481274,-56.632656,-69.984848,
				-2.202045,-14.82914,-37.832645,-22.885981),Channel=c("MEG0111",
				"MEG0121","MEG0131","MEG0141","MEG0211","MEG0221","MEG0231",
				"MEG0241","MEG0311","MEG0321","MEG0331","MEG0341","MEG0411",
				"MEG0421","MEG0431","MEG0441","MEG0511","MEG0521","MEG0531",
				"MEG0541","MEG0611","MEG0621","MEG0631","MEG0641","MEG0711",
				"MEG0721","MEG0731","MEG0741","MEG0811","MEG0821","MEG0911",
				"MEG0921","MEG0931","MEG0941","MEG1011","MEG1021","MEG1031",
				"MEG1041","MEG1111","MEG1121","MEG1131","MEG1141","MEG1211",
				"MEG1221","MEG1231","MEG1241","MEG1311","MEG1321","MEG1331",
				"MEG1341","MEG1411","MEG1421","MEG1431","MEG1441","MEG1511",
				"MEG1521","MEG1531","MEG1541","MEG1611","MEG1621","MEG1631",
				"MEG1641","MEG1711","MEG1721","MEG1731","MEG1741","MEG1811",
				"MEG1821","MEG1831","MEG1841","MEG1911","MEG1921","MEG1931",
				"MEG1941","MEG2011","MEG2021","MEG2031","MEG2041","MEG2111",
				"MEG2121","MEG2131","MEG2141","MEG2211","MEG2221","MEG2231",
				"MEG2241","MEG2311","MEG2321","MEG2331","MEG2341","MEG2411",
				"MEG2421","MEG2431","MEG2441","MEG2511","MEG2521","MEG2531",
				"MEG2541","MEG2611","MEG2621","MEG2631","MEG2641"))
			if(is.null(too.far)){
				too.far<-0.0595
			}
		}else if(coords[1]=="neuromag.306.plan1"){
			coords<-data.frame(x=c(-67.416206,-53.602242,-62.018288,-74.582848,
				-50.595154,-38.599728,-41.41642,-53.280643,-33.790501,-32.014336,
				-21.679966,-43.684467,-26.99799,-15.084751,-15.930935,-28.824663,
				-21.861498,-9.506709,-8.616095,-21.240477,-8.782405,3.032724,
				-3.094766,-9.199021,-3.246834,9.314525,9.387173,-3.422897,
				3.037592,3.034455,15.50483,27.96731,27.254196,14.661931,3.032913,
				14.751018,15.123913,9.200539,21.014965,32.958527,34.757563,
				21.882982,39.958897,49.923473,38.014336,27.600079,44.599728,
				56.558392,59.420483,47.371586,59.704369,73.119286,80.438919,
				67.883209,-65.298943,-61.281609,-65.70282,-73.907913,-50.916454,
				-39.631779,-31.896103,-42.859089,-50.79604,-51.188797,-35.902962,
				-31.408134,-27.801163,-15.685101,-3.600111,-18.483526,-19.866816,
				-14.513481,-17.428471,-30.237587,-4.44193,10.357624,10.645295,
				-4.645079,2.947649,3.000001,14.918572,-8.987089,21.64146,
				33.786499,24.501518,9.641699,25.852789,36.078903,23.363274,
				20.32992,45.64481,56.812263,48.69418,37.896111,41.812634,
				57.171906,56.704624,37.320171,71.13736,79.822243,71.490112,
				67.220192),y=c(35.916687,40.989067,21.17697,10.595787,19.519251,
				20.043873,2.283216,-0.261772,49.930138,35.268585,31.368065,
				36.578434,18.107347,16.453575,2.414510,2.862587,57.939636,
				62.119865,51.80838,46.36343,40.647827,29.760933,17.200909,
				29.131405,4.193846,4.073887,-8.088106,-8.019942,63.507698,
				53.141838,62.155254,57.90871,46.389683,51.858044,42.169956,
				40.654079,29.148697,17.29562,16.412239,18.06213,2.727141,
				2.537710,49.88879,36.414738,35.268585,31.398149,20.043867,
				19.387651,-0.419475,2.283183,41.06303,36.343739,10.835863,
				21.062304,-2.207253,-22.907852,-37.652336,-14.918098,-17.812164,
				-13.820436,-28.078358,-33.676094,-56.582275,-41.557373,
				-55.779526,-69.949036,-11.268716,-10.119589,-19.690945,
				-24.350609,-38.35004,-53.855225,-64.875893,-45.94453,-31.808243,
				-31.789736,-43.790749,-43.744335,-56.389515,-67.862061,
				-76.941826,-76.928932,-10.079389,-11.16998,-24.449615,-19.706125,
				-38.37122,-45.97496,-64.865387,-53.88026,-13.675139,-17.901899,
				-33.77858,-28.078348,-55.800888,-41.481274,-56.632656,-69.984848,
				-2.202045,-14.82914,-37.832645,-22.885981),Channel=c("MEG0112",
				"MEG0122","MEG0132","MEG0142","MEG0212","MEG0222","MEG0232",
				"MEG0242","MEG0312","MEG0322","MEG0332","MEG0342","MEG0412",
				"MEG0422","MEG0432","MEG0442","MEG0512","MEG0522","MEG0532",
				"MEG0542","MEG0612","MEG0622","MEG0632","MEG0642","MEG0712",
				"MEG0722","MEG0732","MEG0742","MEG0812","MEG0822","MEG0912",
				"MEG0922","MEG0932","MEG0942","MEG1012","MEG1022","MEG1032",
				"MEG1042","MEG1112","MEG1122","MEG1132","MEG1142","MEG1212",
				"MEG1222","MEG1232","MEG1242","MEG1312","MEG1322","MEG1332",
				"MEG1342","MEG1412","MEG1422","MEG1432","MEG1442","MEG1512",
				"MEG1522","MEG1532","MEG1542","MEG1612","MEG1622","MEG1632",
				"MEG1642","MEG1712","MEG1722","MEG1732","MEG1742","MEG1812",
				"MEG1822","MEG1832","MEG1842","MEG1912","MEG1922","MEG1932",
				"MEG1942","MEG2012","MEG2022","MEG2032","MEG2042","MEG2112",
				"MEG2122","MEG2132","MEG2142","MEG2212","MEG2222","MEG2232",
				"MEG2242","MEG2312","MEG2322","MEG2332","MEG2342","MEG2412",
				"MEG2422","MEG2432","MEG2442","MEG2512","MEG2522","MEG2532",
				"MEG2542","MEG2612","MEG2622","MEG2632","MEG2642"))
			if(is.null(too.far)){
				too.far<-0.0595
			}
		}else if(coords[1]=="neuromag.306.plan2"){
			coords<-data.frame(x=c(-67.416206,-53.602242,-62.018288,-74.582848,
				-50.595154,-38.599728,-41.41642,-53.280643,-33.790501,-32.014336,
				-21.679966,-43.684467,-26.99799,-15.084751,-15.930935,-28.824663,
				-21.861498,-9.506709,-8.616095,-21.240477,-8.782405,3.032724,
				-3.094766,-9.199021,-3.246834,9.314525,9.387173,-3.422897,
				3.037592,3.034455,15.50483,27.96731,27.254196,14.661931,3.032913,
				14.751018,15.123913,9.200539,21.014965,32.958527,34.757563,
				21.882982,39.958897,49.923473,38.014336,27.600079,44.599728,
				56.558392,59.420483,47.371586,59.704369,73.119286,80.438919,
				67.883209,-65.298943,-61.281609,-65.70282,-73.907913,-50.916454,
				-39.631779,-31.896103,-42.859089,-50.79604,-51.188797,-35.902962,
				-31.408134,-27.801163,-15.685101,-3.600111,-18.483526,-19.866816,
				-14.513481,-17.428471,-30.237587,-4.44193,10.357624,10.645295,
				-4.645079,2.947649,3.000001,14.918572,-8.987089,21.64146,
				33.786499,24.501518,9.641699,25.852789,36.078903,23.363274,
				20.32992,45.64481,56.812263,48.69418,37.896111,41.812634,
				57.171906,56.704624,37.320171,71.13736,79.822243,71.490112,
				67.220192),y=c(35.916687,40.989067,21.17697,10.595787,19.519251,
				20.043873,2.283216,-0.261772,49.930138,35.268585,31.368065,
				36.578434,18.107347,16.453575,2.414510,2.862587,57.939636,
				62.119865,51.80838,46.36343,40.647827,29.760933,17.200909,
				29.131405,4.193846,4.073887,-8.088106,-8.019942,63.507698,
				53.141838,62.155254,57.90871,46.389683,51.858044,42.169956,
				40.654079,29.148697,17.29562,16.412239,18.06213,2.727141,
				2.537710,49.88879,36.414738,35.268585,31.398149,20.043867,
				19.387651,-0.419475,2.283183,41.06303,36.343739,10.835863,
				21.062304,-2.207253,-22.907852,-37.652336,-14.918098,-17.812164,
				-13.820436,-28.078358,-33.676094,-56.582275,-41.557373,
				-55.779526,-69.949036,-11.268716,-10.119589,-19.690945,
				-24.350609,-38.35004,-53.855225,-64.875893,-45.94453,-31.808243,
				-31.789736,-43.790749,-43.744335,-56.389515,-67.862061,
				-76.941826,-76.928932,-10.079389,-11.16998,-24.449615,-19.706125,
				-38.37122,-45.97496,-64.865387,-53.88026,-13.675139,-17.901899,
				-33.77858,-28.078348,-55.800888,-41.481274,-56.632656,-69.984848,
				-2.202045,-14.82914,-37.832645,-22.885981),Channel=c("MEG0113",
				"MEG0123","MEG0133","MEG0143","MEG0213","MEG0223","MEG0233",
				"MEG0243","MEG0313","MEG0323","MEG0333","MEG0343","MEG0413",
				"MEG0423","MEG0433","MEG0443","MEG0513","MEG0523","MEG0533",
				"MEG0543","MEG0613","MEG0623","MEG0633","MEG0643","MEG0713",
				"MEG0723","MEG0733","MEG0743","MEG0813","MEG0823","MEG0913",
				"MEG0923","MEG0933","MEG0943","MEG1013","MEG1023","MEG1033",
				"MEG1043","MEG1113","MEG1123","MEG1133","MEG1143","MEG1213",
				"MEG1223","MEG1233","MEG1243","MEG1313","MEG1323","MEG1333",
				"MEG1343","MEG1413","MEG1423","MEG1433","MEG1443","MEG1513",
				"MEG1523","MEG1533","MEG1543","MEG1613","MEG1623","MEG1633",
				"MEG1643","MEG1713","MEG1723","MEG1733","MEG1743","MEG1813",
				"MEG1823","MEG1833","MEG1843","MEG1913","MEG1923","MEG1933",
				"MEG1943","MEG2013","MEG2023","MEG2033","MEG2043","MEG2113",
				"MEG2123","MEG2133","MEG2143","MEG2213","MEG2223","MEG2233",
				"MEG2243","MEG2313","MEG2323","MEG2333","MEG2343","MEG2413",
				"MEG2423","MEG2433","MEG2443","MEG2513","MEG2523","MEG2533",
				"MEG2543","MEG2613","MEG2623","MEG2633","MEG2643"))
			if(is.null(too.far)){
				too.far<-0.0595
			}
		}
	}

	for(mycn in c("x","y","Channel")){
		if(!mycn%in%colnames(coords)){
			stop(paste("the coordinates data frame does not have column",
				mycn,"\n"))
		}
	}

	if(is.na(too.far)){
		too.far<-0
	}

	A<-as.data.frame(x$A)
	colnames(A)<-x$channel
	A<-as.data.frame(t(A))
	colnames(A)<-paste("IC",1:ncol(A),sep="")
	A$Channel<-as.factor(rownames(A))
	rownames(A)<-1:nrow(A)
	A<-merge(A,coords[,c("x","y","Channel")],by="Channel")
	
	m<-NULL
	eval(parse(text=paste("m<-gam(",paste("IC",ic,sep=""),
		"~te(x,y,bs=bs,k=",k,"),data=A)",sep="")))

    vis.gam(m,color=col,too.far=too.far,main=paste("IC",ic,sep=""),xlab="",
		ylab="",axes=FALSE,frame.plot=FALSE,plot.type="contour",...)
    mtext(xlab,side=1,line=1)
    mtext(ylab,side=2,line=1)
    for(cc in 1:nrow(coords)){
      	points(x=coords[cc,"x"],y=coords[cc,"y"],pch=19,cex=0.5)
    }
}
