% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_utils.R
\name{uniformMap}
\alias{uniformMap}
\title{Uniform recombination maps}
\usage{
uniformMap(Mb = NULL, cM = NULL, M = NULL, cmPerMb = 1, chrom = 1)
}
\arguments{
\item{Mb}{Map length in megabases.}

\item{cM}{Map length in centiMorgan.}

\item{M}{Map length in Morgan.}

\item{cmPerMb}{A positive number; the cM/Mb ratio.}

\item{chrom}{A chromosome label.}
}
\value{
An object of class \code{chromMap}, which is a list of two matrices,
named "male" and "female".
}
\description{
Create a uniform recombination map of a given length.
}
\examples{
uniformMap(M = 1)

m = uniformMap(Mb = 1, cM = 2:3)
}
\seealso{
\code{\link[=loadMap]{loadMap()}}, \code{\link[=customMap]{customMap()}}
}
