% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{ICCplot}
\alias{ICCplot}
\title{Item Characteristic Curves}
\usage{
ICCplot(data, itemnumber, pallete = "Paired", xticks = 1,
  yticks = 0.5, thetain = -6, thetaend = 6, method = "score",
  grid = "yes", cinumber = 6, itemdescrip = "", axis.rumm = "yes",
  dif = "no", difvar = NA, diflabels = c("Group1", "Group 2",
  "Group 3", "Group 4", "Group5"), difstats = "yes",
  title = "Item Characteristic Curve", icclabel = "yes",
  xaxistitle = "Theta", yaxistitle = "Item Score")
}
\arguments{
\item{data}{An object of class "data.frame" containing the items (include all items present in the model).
The variables need to be numeric.}

\item{itemnumber}{A numeric vector indicating the columns of the data (the items) which ICCs are going to be plotted.
Maximum of four items per plot.}

\item{pallete}{An object of class "character". Choose a pre-made color pallete from package RColorBrewer.
Only available for dif="no".}

\item{xticks}{A numeric scalar. Specify x-axis tick values.}

\item{yticks}{A numeric scalar. Specify y-axis tick values.}

\item{thetain}{A numeric scalar. Specify minimum theta values for person parameters.}

\item{thetaend}{A numeric scalar. Specify maximum theta values for person parameters.}

\item{method}{The method for displaying observed scores. Choose "score" to plot total scores.
Choose "cut" to plot class intervals.}

\item{grid}{Chooses whether the background grid should be displayed. Options are "yes" or "no".}

\item{cinumber}{A numeric scalar. The number of adjacent class intervals in which participants will be divided.
Notice that the number of class intervals cannot be higher than the number of total scores.}

\item{itemdescrip}{A character vector indicating the description of the plotted items. Maximum of four descriptions
(one description per item plotted).}

\item{axis.rumm}{Configures whether the plot should display the entire trait range or solely the trait range close
to the observed scores (similar to private software RUMM2030). Options are "yes" or "no".}

\item{dif}{Configures whether the observed scores will be plotted according to values of an exogenous variable
to evaluate differential item function. Options are "yes" or "no".}

\item{difvar}{Chooses the variable which will be used to evaluate differential item functioning. Only
necessary when dif="yes".}

\item{diflabels}{A character vector indicating the labels to values of the variable choosen to evaluate differential item functioning.
Only necessary when dif="yes".}

\item{difstats}{Displays the partial gamma coefficient to indicate the magnitude of differential item
functioning. Options are "yes" or "no". Only necessary when dif="yes".}

\item{title}{A character vector. The title of the plot.}

\item{icclabel}{Displays the labels of Expected Item Score and Observed Item Score. Options are "yes"
or "no".}

\item{xaxistitle}{A character vector. The x-axis title.}

\item{yaxistitle}{A character vector. The y-axis title.}
}
\description{
Plots Item Characteristic Curves for dichotomous and polytomous items. The plot can display observed scores as
total scores (method="score") or as average scores within adjacent class intervals (method="cut").
Class intervals can be useful when the sample size is not large enough to contain an adequate
number of respondents with the same total score for each possible total score. The function includes
the option to plot observed scores according to values of an exogenous variable to evaluate differential item functioning
(dif="yes").
}
\examples{
\dontrun{# Creates a plot for Item 1 using total scores
ICCplot(desc2[,5:13], itemnumber=1, method="score", itemdescrip="Item 1")

# Creates a plot for Item 1 using 8 class intervals
ICCplot(desc2[,5:13], itemnumber=1, method="cut", cinumber=8, itemdescrip="Item 1")

# Creates a plot for Item 1 using 8 class intervals without RUMM style axis
ICCplot(desc2[,5:13], itemnumber=1, method="cut", cinumber=8, itemdescrip="Item 1", axis.rumm="no")

# Creates a plot for Item 3 using 8 class intervals and evaluating DIF according to gender
ICCplot(desc2[,5:13], itemnumber=3, method="cut", cinumber=8, itemdescrip="Item 3",
dif="yes", difvar=desc2$gender, diflabels=c("Men", "Women"))

# Creates a plot with three items using 5 class intervals and evaluating DIF according to gender
ICCplot(desc2[,5:13], itemnumber=1:3, method="cut", cinumber=5,
itemdescrip=c("Item 1","Item 2","Item 3"), dif="yes"
difvar=desc2$gender, diflabels=c("Men", "Women"))
}
}
\author{
Pedro Henrique Ribeiro Santiago \email{pedro.ribeirosantiago@adelaide.edu.au}, Marianne Mueller
}
