% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorMeans.R
\name{factorComp}
\alias{factorComp}
\alias{print.inzfactorcomp}
\title{Compare factor levels}
\usage{
factorComp(fit, factor)

\method{print}{inzfactorcomp}(x, ...)
}
\arguments{
\item{fit}{a lm/glm/svyglm object}

\item{factor}{the name of the factor to compare}

\item{x}{an \code{inzfactorcomp} object}

\item{...}{extra arguments for print (ignored)}
}
\value{
a factor level comparison object with estimates, CIs, and (adjusted) p-values
}
\description{
Computes confidence intervals for the pairwise differences between levels
of a factor, based off of \code{stats::TukeyHSD}.
}
\section{Functions}{
\itemize{
\item \code{print(inzfactorcomp)}: print method for object of class \code{inzfactorcomp}

}}
\examples{
f <- lm(Sepal.Length ~ Sepal.Width + Species, data = iris)
factorComp(f, "Species")
}
\author{
Tom Elliott
}
