\name{Technique 3: Example Methods for Processing Agent Information}

\alias{agent_getMeasureOverTime}
\alias{plotAgents}
\alias{getSpeciesSpecificAbundance}
\alias{plotTimeCourseAgents}
\alias{simpsonIndex}
\alias{getSpeciesAbundance}
\alias{plotTimeCourseAbund}

\title{Technique 3: Example Methods for Processing Agent Information}
\description{
The previous section detailed methods that have been provided for extracting information from an agent_state or agent_sum file. This section describes exemplar methods that have been provided to show how this data can be processed. Remember however that this package has been provided to enable you to access simulation data in R, and we hope that you will be able to build on these methods that we provide. Note that these methods read in the agent_state or agent_sum files, thus there is no need to independently run Technique 1 in this case.\cr
\cr
The following methods are available:\cr
\bold{agent_getMeasureOverTime}: Processes all agent_State or agent_Sum files for a particular simulation run, storing the result for a specified simulation output (such as biomass or growth rate) for each timestep. A data frame of these responses is returned, of one column, with each timestep represented by one row. This information could then be plotted if desired.\cr
\bold{plotAgents}: This routine will plot all the agents for a particular timepoint using the 'agent_State' file. This is useful for examining the location of each species within the biofilm. Each agent is represented by a circle coloured for each species, but note that the sizes of the circles DO NOT correspond to the actual sizes of the agents. If you want a plot of the agents with the correct agent sizes, use POV-Ray to render the pov file output from iDynoMiCS (see iDynoMiCS tutorial).\cr
\bold{getSpeciesSpecificAbundance}: Returns a data frame containing the abundance of each species in the simulation at each time-point. Useful for monitoring growth of populations. \cr
\bold{plotTimeCourseAgents}: This will plot the number of each species at each iteration, as generated by the method above.\cr
\bold{simpsonIndex}: This will plot the diversity of the community at each iteration and return a data frame of the data comprising this graph. This utilises the data frame returned by the method getSpeciesSpecificAbundance. \cr
\bold{getSpeciesAbundance}: Returns a data frame containing the total abundance of individuals (of all species) in the simulation at each time-point.\cr
\bold{plotTimeCourseAbund}: This routine plots the sum of all the abundances of all species, as generated by the method above.\cr}
\usage{
agent_getMeasureOverTime(resultFileFolder, resultFileType, 
numTimepoints, outputPeriod,speciesReqd, columnName)

plotAgents(resultFileFolder, timePoint, folderForGraphOut)

getSpeciesSpecificAbundance(resultFileFolder, numTimepoints, 
outputPeriod)

plotTimeCourseAgents(resultFileFolder, numTimepoints, outputPeriod,
folderForGraphOut)

simpsonIndex(resultFileFolder, numTimepoints, outputPeriod, 
folderForGraphOut)

getSpeciesAbundance(resultFileFolder, numTimepoints, outputPeriod)

plotTimeCourseAbund(resultFileFolder, numTimepoints, outputPeriod, 
folderForGraphOut)

}
\arguments{
   \item{resultFileFolder}{The directory where iDynoMiCS stored the simulation output files.}
   \item{resultFileType}{The output response file type to read in. This should be either agent_State, agent_Sum, env_State, or env_Sum}
   \item{numTimepoints}{The number of timepoints comprising this simulation run}
   \item{outputPeriod}{The number of timepoints between simulation output. See protocol file tutorial}
   \item{timePoint}{A particular timepoint from which the agent positions should be plotted}
   \item{folderForGraphOut}{Each graph is output to file. This should specify the folder where the graph should be written to}
   \item{speciesReqd}{The name of the species of interest, as a string}
   \item{columnName}{A string containing the column of the result file (or simulation response) of interest (such as biomass)}
}

\examples{
\dontrun{
# DONTRUN IS SET SO THIS IS NOT EXECUTED WHEN PACKAGE IS COMPILED - BUT THIS
# HAS BEEN TESTED THOROUGHLY BEFORE UPLOADING TO THE REPOSITORY

# Track the biomass of Pseudomonas over time, for 48 timepoints
# with an output period of 1
totalBiomass<-agent_getMeasureOverTime("/home/user/iDynoMiCS/results/", 
"agent_State", 48, 1, "Pseudomonas", "biomass")

# Plot all the agents in the simulation at the 24th timestep
plotAgents("/home/user/iDynoMiCS/results/", 24, "/home/user/iDynoMiCS/results")

# Get the abundance of each species throughout a simulation of 48 timepoints
# with an output period of 1
speciesAbundance<-getSpeciesSpecificAbundance("/home/user/iDynoMiCS/results/", 
48,1)

# Plot the abundance of each species, 48 timepoints, output period of 1
plotTimeCourseAgents("/home/user/iDynoMiCS/results/", 48, 1,
"/home/user/Desktop/iDynoMiCS/results/single_species/graphs/")

# Produce a diversity plot of this information, and store the data in the graph
# 48 timepoints, output period of 1
simpsonData<-simpsonIndex("/home/user/iDynoMiCS/results/", 48, 1,
"/home/user/Desktop/iDynoMiCS/results/single_species/graphs/")

# Get the total abundance of individuals throughout the simulation
# 48 timepoints, output period of 1
totalAbundance<-getSpeciesAbundance("/home/user/iDynoMiCS/results/", 48, 1)

# Plot the total abundance. 48 timepoints, output period of 1
plotTimeCourseAbund("/home/user/iDynoMiCS/results/", 48, 1,
"/home/user/iDynoMiCS/results/graphs/")

}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{agent_state}
\keyword{agent_sum}
\keyword{graphs}
\keyword{example-methods}
