% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{IARphit}
\alias{IARphit}
\title{Minus Log Likelihood IAR-T Model}
\usage{
IARphit(x, y, st, nu = 3)
}
\arguments{
\item{x}{An array with the parameters of the IAR-T model. The first element of the array corresponding to the phi parameter and the second element to the scale parameter sigma}

\item{y}{Array with the time series observations}

\item{st}{Array with the irregular observational times}

\item{nu}{degrees of freedom}
}
\value{
Value of the negative log likelihood evaluated in phi,sigma and nu.
}
\description{
This function return the negative log likelihood of the IAR-T given specific values of phi and sigma.
}
\examples{
n=300
set.seed(6714)
st<-gentime(n) #Unequally spaced times
y<-IARtsample(n,0.9,st,sigma2=1,nu=3)
IARphit(x=c(0.9,1),y=y$y,st=st)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARgsample}}
}
