% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{IARphigamma}
\alias{IARphigamma}
\title{Minus Log Likelihood IAR-Gamma Model}
\usage{
IARphigamma(x_input, y, st)
}
\arguments{
\item{x_input}{An array with the parameters of the IAR-Gamma model. The first element of the array corresponding to the phi parameter, the second to the level parameter mu, and the last one to the scale parameter sigma.}

\item{y}{Array with the time series observations.}

\item{st}{Array with the irregular observational times.}
}
\value{
Value of the negative log likelihood evaluated in phi, mu and sigma.
}
\description{
This function return the negative log likelihood of the IAR-Gamma given specific values of phi, mu and sigma.
}
\examples{
n=100
set.seed(6714)
st<-gentime(n)
y<-IARgsample(phi=0.9,st=st,n=n,sigma2=1,mu=1)
IARphigamma(x_input=c(0.9,1,1),y=y$y,st=st)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARgsample}}
}
