% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIARphikalman.R
\name{CIAR.phi.kalman}
\alias{CIAR.phi.kalman}
\title{Minus Log Likelihood of the CIAR Model}
\usage{
CIAR.phi.kalman(x, y, t, yerr, zero.mean = "TRUE", standarized = "TRUE", c = 1)
}
\arguments{
\item{x}{An array with the parameters of the CIAR model. The elements of the array are, in order, the real (phi.R) and the imaginary (phi.I) part of the coefficient of CIAR model.}

\item{y}{Array with the time series observations.}

\item{t}{Array with the irregular observational times.}

\item{yerr}{Array with the measurements error standard deviations.}

\item{zero.mean}{logical; if true, the array y has zero mean; if false, y has a mean different from zero.}

\item{standarized}{logical; if true, the array y is standarized; if false, y contains the raw time series.}

\item{c}{Nuisance parameter corresponding to the variance of the imaginary part.}
}
\value{
Value of the negative log likelihood evaluated in phiR and phiI.
}
\description{
This function return the negative log likelihood of the CIAR process given specific values of phi.R and phi.I
}
\examples{
n=300
set.seed(6714)
st<-gentime(n)
x=CIAR.sample(n=n,phi.R=0.9,phi.I=0,sT=st,c=1)
y=x$y
yerr=rep(0,n)
CIAR.phi.kalman(x=c(0.8,0),y=y,t=st,yerr=yerr)
}
\references{
\insertRef{Elorrieta_2019}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{CIAR.sample}}
}
