% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIARsample.R
\name{BIAR.sample}
\alias{BIAR.sample}
\title{Simulate from a BIAR Model}
\usage{
BIAR.sample(n, sT, phi.R, phi.I, delta1 = 0, delta2 = 0, rho = 0)
}
\arguments{
\item{n}{Length of the output bivariate time series. A strictly positive integer.}

\item{sT}{Array with observational times.}

\item{phi.R}{Autocorrelation coefficient of BIAR model. A value between -1 and 1.}

\item{phi.I}{Crosscorrelation coefficient of BIAR model. A value between -1 and 1.}

\item{delta1}{Array with the measurements error standard deviations of the first time series of the bivariate process.}

\item{delta2}{Array with the measurements error standard deviations of the second time series of the bivariate process.}

\item{rho}{Contemporary correlation coefficient of BIAR model. A value between -1 and 1.}
}
\value{
A list with the following components:
\itemize{
\item{y}{ Matrix with the simulated BIAR process.}
\item{t}{ Array with observation times.}
\item{Sigma}{ Covariance matrix of the process.}
}
}
\description{
Simulates a BIAR Time Series Model
}
\details{
The chosen phi.R and phi.I values must satisfy the condition $|phi.R + i phi.I| < 1$.
}
\examples{
n=300
set.seed(6714)
st<-gentime(n)
x=BIAR.sample(n=n,phi.R=0.9,phi.I=0.3,sT=st)
plot(st,x$y[1,],type='l')
plot(st,x$y[2,],type='l')
x=BIAR.sample(n=n,phi.R=-0.9,phi.I=-0.3,sT=st)
plot(st,x$y[1,],type='l')
plot(st,x$y[2,],type='l')
}
\seealso{
\code{\link{gentime}}
}
