\name{hzar.extract.old.model.gen}
\alias{hzar.extract.old.model.gen}
\alias{hzar.extract.old.model.req}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Extract information about the clineMetaModel used.
%%  ~~function to do ... ~~
}
\description{
  These methods extract the \code{$func} and \code{$req} methods from
  the \code{\link{clineMetaModel}} object used initially.  This includes
  modifications specified by the \code{$parameterTypes} item.
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
hzar.extract.old.model.gen(fitRequest)
hzar.extract.old.model.req(fitRequest)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{fitRequest}{
    A \code{\link{hzar.fitRequest}} or a \code{\link{hzar.dataGroup}}
    object, or a log likelihood function generated by hzar.
  }
}

\value{
  A method which takes the cline parameters as arguments, with the fixed
  parameters set to default values.
  
  The result of that method is boolean for
  \code{hzar.extract.old.model.req} and a function of distance for 
  \code{hzar.extract.old.model.gen}.
}
% \references{
% %% ~put references to the literature/web site here ~
% }
\author{
Graham Derryberry \email{asterion@alum.mit.edu}

}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
  \code{\link{hzar.fitRequest}}
  \code{\link{hzar.dataGroup}}
  \code{\link{clineMetaModel}}
  \code{\link{hzar.first.fitRequest.old.ML}}
}
\examples{

data(manakinMolecular);
ASdata <-
  hzar.doMolecularData1DPops(distance=manakinMolecular$distance,
                             pObs=manakinMolecular$ak2.A,
                             nEff=manakinMolecular$ak2.nSamples);
ASclineM <- hzar.makeCline1DFreq(data=ASdata,scaling="none", tails="none");
ASclineM$func;
ASclineM$req;
ASfitA <- hzar.first.fitRequest.old.ML(ASclineM,ASdata)
hzar.extract.old.model.gen(ASfitA)
hzar.extract.old.model.req(ASfitA)

}
% % Add one or more standard keywords, see file 'KEYWORDS' in the
% % R documentation directory.
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
