% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pois_errorI.R
\name{pois_errorI}
\alias{pois_errorI}
\title{Empirical Error Type I Associated with a Poisson Distribution}
\usage{
pois_errorI(c = 1, n = 100, theta0 = 1, R = 15000)
}
\arguments{
\item{c}{numeric, represents a positive value that defines a critical region. Default value is 1.}

\item{n}{numeric, represents the size of the sample. Default value is 100.}

\item{theta0}{numeric, represents the location parameter under the null hypothesis of a sample from a Poisson distribution. Default value is 1.}

\item{R}{numeric, represents the number of replicates. Default value is 15000.}
}
\value{
A list with number of replicates, sample size, and critical value that were used in the calculation of error type I
associated with a likelihood ratio statistic.
}
\description{
\code{pois_errorI} is used to obtain an empirical error type I when we use a random sample from a Poisson distribution.
}
\examples{
# Error type I when we use a random sample of size 200 from an Poisson distribution,
# a critical value c = 0.85 and R = 20000 to test H_0: theta = 2 vs H_1: theta != 2
pois_errorI(0.85,n=100,theta0=2,R=20000)
}
\references{
Casella, G. and Berger, R. (2003). Statistical Inference, Second Edition. Duxbury Press.

Hogg, R., McKean, J., and Craig, A. (2019) Introduction to Mathematical Statistic.  Eighth edition. Pearson.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
