% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_c_opt.R
\name{exp_c_opt}
\alias{exp_c_opt}
\title{Critical Value Given a Nominal Error Type I Associated with a Exponential Distribution}
\usage{
exp_c_opt(
  alpha = 0.1,
  n = 100,
  theta0 = 1,
  c1 = 0.001,
  c2 = 0.99,
  R = 15000,
  delta = 0.005,
  tolerance = 0.01,
  max_iter = 100
)
}
\arguments{
\item{alpha}{numeric, represents a nominal error type I. Default value is 0.1.}

\item{n}{numeric, represents the size of the sample. Default value is 100.}

\item{theta0}{numeric, represents the location parameter under the null hypothesis of a sample from a Exponential distribution. Default value is 0.5.}

\item{c1}{numeric, represents a lower bound to the critical value. Default value is 1e-03.}

\item{c2}{numeric, represents an upper bound to the critical value. Default value is 0.99.}

\item{R}{numeric, represents the number of replicates. Default value is 15000.}

\item{delta}{numeric, represents a precision parameter. Default value is 0.005.}

\item{tolerance}{numeric, represents a relative precision with respect a given alpha. Default value is 0.01.}

\item{max_iter}{integer, represents the maximum number of iterations. Default value is 100.}
}
\value{
A list with number of replicates, sample size, nominal error type I, and empirical critical value obtained
associated with a likelihood ratio statistic.
}
\description{
\code{exp_c_opt} is used to obtain a critical value to achieve a nominal error type I when we use a random sample from a Exponential distribution.
}
\examples{
# Critical value when we use a random sample of size 200 from a Exponential distribution
# given a nominal error type I equals to 0.1 and R = 15000
# to test H_0: theta = 2 vs H_1: theta != 2
exp_c_opt(alpha=0.1,n=200,theta0=2,R=15000)
}
\references{
Casella, G. and Berger, R. (2003). Statistical Inference, Second Edition. Duxbury Press.

Hogg, R., McKean, J., and Craig, A. (2019) Introduction to Mathematical Statistic.  Eighth edition. Pearson.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
