% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ber_errorI.R
\name{ber_errorI}
\alias{ber_errorI}
\title{Empirical Error Type I Associated with a Bernoulli Distribution}
\usage{
ber_errorI(c = 1, n = 150, theta0 = 0.5, R = 12000)
}
\arguments{
\item{c}{numeric, represents a positive value that defines a critical region. Default value is 1.}

\item{n}{numeric, represents the size of the sample. Default value is 100.}

\item{theta0}{numeric, represents the location parameter under the null hypothesis of a sample from a Bernoulli distribution. Default value is 0.5.}

\item{R}{numeric, represents the number of replicates. Default value is 15000.}
}
\value{
A list with number of replicates, sample size, and critical value that were used in the calculation of error type I
associated with a likelihood ratio statistic.
}
\description{
\code{ber_errorI} is used to obtain an empirical error type I when we use a random sample from a Bernoulli distribution.
}
\examples{
# Error type I when we use a random sample of size 200 from a Bernoulli distribution,
# a critical value c = 0.45 and R = 20000 to test H_0: theta = 0.7 vs H_1: theta != 0.7
ber_errorI(0.45,n=100,theta0=0.7,R=20000)
}
\references{
Casella, G. and Berger, R. (2003). Statistical Inference, Second Edition. Duxbury Press.

Hogg, R., McKean, J., and Craig, A. (2019) Introduction to Mathematical Statistic.  Eighth edition. Pearson.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
