% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypr.R
\name{+,hypr,hypr-method}
\alias{+,hypr,hypr-method}
\alias{*,hypr,hypr-method}
\alias{&,hypr,hypr-method}
\alias{/,hypr,hypr-method}
\title{Combining hypr objects by addition or interaction}
\usage{
\S4method{+}{hypr,hypr}(e1, e2)

\S4method{*}{hypr,hypr}(e1, e2)

\S4method{&}{hypr,hypr}(e1, e2)

\S4method{/}{hypr,hypr}(e1, e2)
}
\arguments{
\item{e1, e2}{\code{hypr} objects to concatenate}
}
\value{
The combined \code{hypr} object
}
\description{
You can combine one or more \code{hypr} objects, i.e. combine their hypothesis to a single \code{hypr} object, by adding them with the \code{+} or \code{\*} operators.
}
\section{Functions}{
\itemize{
\item \code{*,hypr,hypr-method}: Interaction of \code{e1} and \code{e2}

\item \code{&,hypr,hypr-method}: Interaction and main contrasts of \code{e1} and \code{e2}

\item \code{/,hypr,hypr-method}: Nesting levels of \code{e2} within \code{e1}
}}

\examples{

(h1 <- hypr(a~i, b~i)) # a hypr object of two treatments

(h2 <- hypr(i~0)) # an intercept-only hypr object

hc <- h1 + h2

hc

interaction <- h1 & h2

interaction_and_main <- h1 * h2

}
