% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypr.R
\name{centered_contrasts}
\alias{centered_contrasts}
\alias{is_centered}
\alias{all_centered}
\alias{which_centered}
\title{Contrast centering}
\usage{
centered_contrasts(x)

is_centered(x)

all_centered(x, ignore_intercept = TRUE)

which_centered(x)
}
\arguments{
\item{x}{A hypr object}

\item{ignore_intercept}{If \code{TRUE}, the intercept is ignored}
}
\value{
A centered set of hypr contrasts (\code{centered_contrasts}), a single logical value (\code{all_centered}), a logical vector (\code{is_centered}), or an integer index vector (\code{which_centered})
}
\description{
Centeredness of contrasts is critical for the interpretation of interactions and intercepts. There are functions available to check for centered contrasts and to realign contrasts so that they are centered.
}
\details{
The function \code{centered_contrasts(x)} will return a copy of \code{x} where all contrasts were centered to a zero mean.

The functions \code{is_centered(x)} and \code{which_centered()} indicate which contrasts of \code{x}, are centered. \code{all_centered(x)} will return \code{TRUE} if all contrasts in \code{x} are centered or \code{FALSE} if at least one contrast is not.
}
\section{Functions}{
\itemize{
\item \code{is_centered}: Check which contrasts of \code{x} are centered

\item \code{all_centered}: Check whether all contrasts of \code{x} are centered

\item \code{which_centered}: Check which contrasts of \code{x} are centered
}}

