% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lprofitDEA.R
\name{lprofitDEA}
\alias{lprofitDEA}
\title{Linear profit DEA model}
\usage{
lprofitDEA(X, Y, pX, pY, RTS = "crs")
}
\arguments{
\item{X}{Vector, matrix or dataframe with DMUs as rows and inputs as columns}

\item{Y}{Vector, matrix or dataframe with DMUs as rows and outputs as columns}

\item{pX}{Vector, matrix or dataframe with prices for each DMU and input.
Therefore it must have the same dimensions as X.}

\item{pY}{Vector, matrix or dataframe with prices for each DMU and output.
Therefore it must have the same dimensions as Y.}

\item{RTS}{Character string indicating the returns-to-scale, e.g. "crs", "vrs".}
}
\value{
A list object containing the following:
\item{lambdas}{Estimated values for the composition of the respective Benchmarks. The lambdas are stored in a matrix with dimensions nrow(X) x nrow(X), where the row is the DMU under observation and the columns are the peers used for the Benchmark.}
\item{opt_value}{Optimal inputs and outputs.}
\item{profit_eff}{Profit efficiency as the ratio of the differences between the observed and optimal difference of cost to revenue.}
}
\description{
Linear profit DEA model optimizing the difference of cost to revenue.
It returns the estimated lambdas as well as the optimal values for inputs and outputs.
The linear profit estimation does not account for scale differences and also has issues
with negative profits. Therefore, it is recommended to use the non-linear profit model.
}
\examples{
X <- matrix(c(1,2,3,3,2,1,2,2), ncol = 2)
Y <- matrix(c(1,1,1,1), ncol = 1)

pX <- matrix(c(2,1,2,1,2,1,1,2), ncol =  2, byrow = TRUE)
pY <- matrix(c(1,1,1,1), ncol = 1)

max_prof_lin<- lprofitDEA(X,Y,pX,pY)

}
\seealso{
[Benchmarking::profit.opt] for a similar function
}
\author{
Alexander Öttl
}
