% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeraster.R
\name{makeraster}
\alias{makeraster}
\alias{fitraster}
\title{makeraster}
\usage{
makeraster(x, startx, d, newlevels, tol = 0.1)

fitraster(x, tol = 0.1)
}
\arguments{
\item{x}{numeric to be fitted with a raster}

\item{startx}{starting point ("origin") for calculation of the raster}

\item{d}{step size of the raster}

\item{newlevels}{levels of the raster}

\item{tol}{tolerance for rounding to new levels: elements of x within \code{tol} of the distance between the levels of the new grid are rounded to the new grid point.}
}
\value{
list with elements
\item{x}{the values of \code{x}, possibly rounded to the raster values}
\item{levels}{the values of the raster}
}
\description{
find an evenly spaced grid for x
}
\details{
\code{makeraster} fits the data to the specified raster.

\code{fitraster} tries different raster parameter and returns the raster that covers most of the
\code{x} values: The differences between the values of \code{x} are calculated (possible step
sizes). For each of those step sizes, different points are tried (until all points have been
covered by a raster) and the parameter combination leading to the best coverage (i.e. most points
on the grid) ist used.

Note that only differences between the sorted values of x are considered as step size.
}
\examples{
x <- c (sample (1:20, 10), (0 : 5) + 0.5)
raster <- makeraster (x, x [1], 2)
raster
plot (x)
abline (h = raster$levels, col = "#00000040")

## unoccupied levels
missing <- setdiff (raster$levels, raster$x)
abline (h = missing, col = "red")

## points acutally on the raster
onraster <- raster$x \%in\% raster$levels
points (which (onraster), raster$x [onraster], col = "blue", pch = 20)


raster <- fitraster (x)
raster
plot (x)
abline (h = raster$levels, col = "#00000040")

## unoccupied levels
missing <- setdiff (raster$levels, raster$x)
abline (h = missing, col = "red")

## points acutally on the raster
onraster <- raster$x \%in\% raster$levels
points (which (onraster), raster$x [onraster], col = "blue", pch = 20)

x <- c (sample (1:20, 10), (0 : 5) + 0.45)
raster <- fitraster (x)
raster
plot (x)
abline (h = raster$levels, col = "#00000040")

## unoccupied levels
missing <- setdiff (raster$levels, raster$x)
abline (h = missing, col = "red")

## points acutally on the raster
onraster <- raster$x \%in\% raster$levels
points (which (onraster), raster$x [onraster], col = "blue", pch = 20)

}
\author{
Claudia Beleites
}
