% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qplot.R
\name{qplotmap}
\alias{qplotmap}
\title{Spectra plotting with ggplot2}
\usage{
qplotmap(object, mapping = aes_string(x = "x", y = "y", fill = "spc"), ...,
  func = mean, func.args = list(), map.tileonly = FALSE)
}
\arguments{
\item{object}{hyperSpec object}

\item{mapping}{see  \code{\link[ggplot2]{geom_tile}}}

\item{...}{handed to \code{\link[ggplot2]{geom_tile}}}

\item{func}{function to summarize the wavelengths}

\item{func.args}{arguments to \code{func}}

\item{map.tileonly}{if \code{TRUE}, \code{mapping} will be handed to
\code{\link[ggplot2]{geom_tile}} instead of \code{\link[ggplot2]{ggplot}}.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object
}
\description{
Spectra plotting with ggplot2
}
\details{
These functions are still experimental and may change substantially in future.

Note that \code{qplotmap} will currently produce the wrong scales if x or y are discrete.
}
\examples{
qplotmap (chondro)
qplotmap (chondro) + scale_fill_gradientn (colours = alois.palette ())
}
\seealso{
\code{\link{plotmap}}

\code{\link[ggplot2]{ggplot}}\code{\link[ggplot2]{geom_tile}}
}
\author{
Claudia Beleites
}
