% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpatialMap.R
\name{getSpatialMap_comb}
\alias{getSpatialMap_comb}
\title{Combine maps together}
\usage{
getSpatialMap_comb(
  ...,
  list = NULL,
  nrow = 1,
  x = "",
  y = "",
  title = "",
  output = FALSE
)
}
\arguments{
\item{...}{different maps generated by \code{getSpatialMap(, output = 'ggplot')}, see details.}

\item{list}{If input is a list containing different ggplot data, use \code{list = inputlist}.}

\item{nrow}{A number showing the number of rows.}

\item{x}{A string of x axis name.}

\item{y}{A string of y axis name.}

\item{title}{A string of the title.}

\item{output}{A boolean, if chosen TRUE, the output will be given.}
}
\value{
A combined map.
}
\description{
Combine maps together
}
\details{
For \code{getSpatialMap_comb}, the maps to be compared should be with same size and resolution, 
in other words, they should be fully overlapped by each other.

If they have different resolutions, use \code{interpGridData{ecomsUDG.Raccess}} to interpolate.
}
\examples{


\dontrun{
data(tgridData)# the result of \code{\link{loadNcdf}}
#The output should be 'ggplot'
a1 <- getSpatialMap(tgridData, method = 'summer', output = 'ggplot', name = 'a1')
a2 <- getSpatialMap(tgridData, method = 'winter', output = 'ggplot', name = 'a2')
a3 <- getSpatialMap(tgridData, method = 'mean', output = 'ggplot', name = 'a3')
a4 <- getSpatialMap(tgridData, method = 'max', output = 'ggplot', name = 'a4')
getSpatialMap_comb(a1, a2)

# or you can put them into a list.
getSpatialMap_comb(list = list(a1, a2), nrow = 2)
}



# More examples can be found in the user manual on https://yuanchao-xu.github.io/hyfo/

}
\references{
\itemize{
\item H. Wickham. ggplot2: elegant graphics for data analysis. Springer New York, 2009.
}
}
